<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/*
 * Home Model
 */

class Home_model extends CI_Model
{
	public function __construct ()
	{
		parent::__construct ();
	}

	//proverka dali postoi korisnikot
	public function check_login($username, $password)
	{
        $this->db->select("*");
		$this->db->where("aktiven", 1);
        $this->db->where("username", $username);
		$this->db->where("password", $password);
        $result = $this->db->get("korisnici");
		
		if($result->num_rows())
			return $result->row()->username;
		return FALSE;
	}
	
	//proverka dali postoi korisnikot preku rfid karticka
	public function check_login_rfid($rfid)
	{
        $this->db->select("*");
		$this->db->where("aktiven", 1);
        $this->db->where("kod_karticka", $rfid);
        $result = $this->db->get("korisnici");
		if($result->num_rows())
			return $result->row()->username;
		return FALSE;
	}
	
	//zema podatoci za korisnikot
	public function get_client ($username)
	{
        $this->db->select("*");
		$this->db->where("aktiven", 1);
        $this->db->where("username", $username);
        return $this->db->get("korisnici");
	}
	
	//zema podatoci za korisnik od tabelata korisnici i od tabelata smena
	public function get_all_data_client ($ime, $limit = 1)
	{
        $this->db->select("*");
		$this->db->where("aktiven", 1);
        $this->db->where("ime", $ime);
		$this->db->join("smena", "smena.korisnik_id = korisnici.id", "left");
		$this->db->order_by("od_datum", 'desc');
		$this->db->limit($limit);
        return $this->db->get("korisnici");
	}
	
	//gi zema site korisnici
	public function get_all_employees ()
	{
        $this->db->select("*");
		$this->db->order_by("id","desc");
        return $this->db->get("korisnici");
	}
	
	//zema id za korisnik spored ime i prezime
	public function get_korisnik ($ime, $prezime)
	{
        $this->db->select("id");
		$this->db->from("korisnici");
        $this->db->where("ime", $ime);
		if (strlen($prezime) > 0) {
			$this->db->where("prezime", $prezime);
		}
        $query = $this->db->get();
		
        return $query->result();
	}
	
	//insert na smena vo baza
	 public function insert_smena($smena, $from_date, $to_date, $korisnik_id)
	 {
		 $dataInsert = array(
                "korisnik_id"    => $korisnik_id,
                "od_datum"       => $from_date,
                "do_datum"       => $to_date,
                "smena"    		 => $smena
            );
		 
        $this->db->insert('smena', $dataInsert);
	 }
	
	//insert na lokacija vo baza
	 public function insert_lokacija($lokacija, $from_date, $to_date, $korisnik_id)
	 {
		 $dataInsert = array(
                "korisnik_id"    => $korisnik_id,
                "od_datum"       => $from_date,
                "do_datum"       => $to_date,
                "lokacija"    		 => $lokacija
            );
		 
        $this->db->insert('lokacija', $dataInsert);
	 }
	 
	 //zema smena za odreden period
	public function odbrana_smena ($korisnik_id, $from_date, $to_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $from_date);
		$this->db->where("do_datum <=", $to_date);
		$this->db->where("korisnik_id", $korisnik_id);
        return $this->db->get("smena");
	}
	
	//zema lokacija za odreden period
	public function odbrana_lokacija ($korisnik_id, $from_date, $to_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $from_date);
		$this->db->where("do_datum <=", $to_date);
		$this->db->where("korisnik_id", $korisnik_id);
        return $this->db->get("lokacija");
	}
	
	//zema meni za odreden period
	public function odbrano_meni ($korisnik_id, $from_date, $to_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $from_date);
		$this->db->where("do_datum <=", $to_date);
		$this->db->where("korisnik_id", $korisnik_id);
        return $this->db->get("odbereno_meni");
	}
	
	//proveruva dali ima smena za daden period
	public function proveri_smena_za_period ($korisnik_id, $from_date, $to_date)
	{
        $this->db->select("*");
		$this->db->from("smena");
		$this->db->where("od_datum >=", $from_date);
		$this->db->where("do_datum <=", $to_date);
		$this->db->where("korisnik_id", $korisnik_id);
        $query = $this->db->get();

        return $query->result();
	}
	
	//proveruva dali ima lokacija za daden period
	public function proveri_lokacija_za_period ($korisnik_id, $from_date, $to_date)
	{
        $this->db->select("*");
		$this->db->from("lokacija");
		$this->db->where("od_datum >=", $from_date);
		$this->db->where("do_datum <=", $to_date);
		$this->db->where("korisnik_id", $korisnik_id);
        $query = $this->db->get();

        return $query->result();
	}
	
	//proveruva dali ima meni za daden period
	public function proveri_meni_za_period ($korisnik_id, $from_date, $to_date)
	{
        $this->db->select("*");
		$this->db->from("odbereno_meni");
		$this->db->where("od_datum >=", $from_date);
		$this->db->where("do_datum <=", $to_date);
		$this->db->where("korisnik_id", $korisnik_id);
        $query = $this->db->get();

        return $query->result();
	}
	
	//brise smena za daden period
	public function izbrisi_smena_za_period($k_id, $od_datum, $do_datum)
	{
		$this->db->where("od_datum >=", $od_datum);
		$this->db->where("do_datum <=", $do_datum);
		$this->db->where("korisnik_id", $k_id);
		$this->db->delete("smena");
	}
	
	//brise lokacija za daden period
	public function izbrisi_lokacija_za_period($k_id, $od_datum, $do_datum)
	{
		$this->db->where("od_datum >=", $od_datum);
		$this->db->where("do_datum <=", $do_datum);
		$this->db->where("korisnik_id", $k_id);
		$this->db->delete("lokacija");
	}
	
	//brise meni za daden period
	public function izbrisi_meni_za_period($k_id, $od_datum, $do_datum)
	{
		$this->db->where("od_datum >=", $od_datum);
		$this->db->where("do_datum <=", $do_datum);
		$this->db->where("korisnik_id", $k_id);
		$this->db->delete("odbereno_meni");
	}
	
	 //brisenje na vraboten
	 public function delete_employee($ime, $prezime)
	 {
		$this->db->where('ime', $ime);
		 if (strlen($prezime) > 0) {
			$this->db->where("prezime", $prezime);
		}
		$this->db->delete('korisnici');
	 }
	 
	 //insert na korisnik vo baza
	 public function nov_vraboten($novo_ime, $novo_prezime, $kod_karticka, $uloga, $korisnicko_ime, $lozinka)
	 {
		 $dataKorisnik = array(
                "ime"    		=> $novo_ime,
                "prezime"       => $novo_prezime,
                "kod_karticka"  => $kod_karticka,
                "uloga"    		=> $uloga,
				"username"    	=> $korisnicko_ime,
				"password"      => $lozinka
            );
			
		$this->db->insert('korisnici', $dataKorisnik);
		
		if ($this->db->affected_rows())
			return TRUE;
		else
			return FALSE;
	 }
	
		 	 //insert na korisnik vo baza
	 public function nov_vraboten_operator_hrana($novo_ime, $novo_prezime, $kod_karticka, $uloga)
	 {
		 $username = $novo_ime.".".$novo_prezime;
		 $dataKorisnik = array(
                "ime"    		=> $novo_ime,
                "prezime"       => $novo_prezime,
                "kod_karticka"  => $kod_karticka,
                "uloga"    		=> $uloga,
				"username"    	=> $username,
				"password"      => $kod_karticka
            );
			
		$this->db->insert('korisnici', $dataKorisnik);
		
		if ($this->db->affected_rows())
			return TRUE;
		else
			return FALSE;
	 }
	 
	 //insert na otsustvo na vraboten vo baza
	 public function otsustvo($vraboten, $start_date, $end_date, $tip_otsustvo)
	 {
		 $dataOtsustvo = array(
                "korisnik_id"    	=> $vraboten,
                "datum_denovi_od"   => $start_date,
                "datum_denovi_do"   => $end_date,
                "tip_na_otsustvo"   => $tip_otsustvo
            );
			
		$this->db->insert('otsustvo', $dataOtsustvo);
		
		if ($this->db->affected_rows())
			return TRUE;
		else
			return FALSE;
	 }
	 
	 //proveruva dali ima vneseno meni za daden period
	public function postoi_meni_za_period($start_date,$end_date,$meni_za_den,$izbor_meni)
	{
        $this->db->select("*");
		$this->db->from("meni");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("den", $meni_za_den);
		$this->db->where("meni", $izbor_meni);
        $query = $this->db->get();

        return $query->result();
	}
	
	// brisenje na vnesenoto meni za daden period
	public function delete_meni($start_date,$end_date,$meni_za_den,$izbor_meni)
	{
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("den", $meni_za_den);
		$this->db->where("meni", $izbor_meni);
		$this->db->delete("meni");
	}
	
	 //insert na meni vo baza
	 public function vnesi_meni($start_date, $end_date, $meni_za_den, $izbor_meni, $jadenje)
	 {
		 $dataMeni = array(
                "od_datum"   => $start_date,
                "do_datum"   => $end_date,
                "den"   	 => $meni_za_den,
				"meni"       => $izbor_meni,
				"jadenje"    => $jadenje
            );
			
		$this->db->insert('meni', $dataMeni);
		
	//	if ($this->db->affected_rows())
	//		return TRUE;
	//	else
	//		return FALSE;
	 }
	 
	 //insert na odbereno meni vo baza
	 public function insert_odbrano_meni($ponedelnik, $vtornik, $sreda, $cetvrtok, $petok, $sabota, $nedela, $from_date, $to_date, $korisnik_id)
	 {
		 $dataOdberenoMeni = array(
                "korisnik_id"    => $korisnik_id,
                "od_datum"       => $from_date,
                "do_datum"       => $to_date,
                "ponedelnik"     => $ponedelnik,
				"vtornik"        => $vtornik,
				"sreda"     	 => $sreda,
				"cetvrtok"    	 => $cetvrtok,
				"petok"   		 => $petok,
				"sabota"     	 => $sabota,
			 	"nedela"     	 => $nedela
            );

        $this->db->insert('odbereno_meni', $dataOdberenoMeni);
	 }
	
	//zema meni za podolg period
	public function pregled_meni($start_date, $end_date)
	{
        $this->db->select("*");
	//	$this->db->from("meni");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
        return $this->db->get("meni");
	//	$query = $this->db->get();

        return $query->result();
	}
	 
	 //zema meni za period
	public function get_meni($start_date, $end_date)
	{
        $this->db->select("*");
		//$this->db->from("meni");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
        return $this->db->get("meni");
		//$query = $this->db->get();

        //return $query->result();
	}
	
	//zema meni1 za ponedelnik
	public function get_meni1_ponedelnik($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "1");
		$this->db->where("den", "ponedelnik");
        return $this->db->get("meni");
	}
	
	//zema meni2 za ponedelnik
	public function get_meni2_ponedelnik($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "2");
		$this->db->where("den", "ponedelnik");
        return $this->db->get("meni");;
	}
	
	//zema meni3 za ponedelnik
	public function get_meni3_ponedelnik($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "3");
		$this->db->where("den", "ponedelnik");
        return $this->db->get("meni");;
	}
	
	//zema meni4 za ponedelnik
	public function get_meni4_ponedelnik($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "4");
		$this->db->where("den", "ponedelnik");
        return $this->db->get("meni");;
	}
	
	//zema meni5 za ponedelnik
	public function get_meni5_ponedelnik($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "5");
		$this->db->where("den", "ponedelnik");
        return $this->db->get("meni");;
	}
	
	//zema meni6 za ponedelnik
	public function get_meni6_ponedelnik($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "6");
		$this->db->where("den", "ponedelnik");
        return $this->db->get("meni");;
	}
	
	//zema meni7 za ponedelnik
	public function get_meni7_ponedelnik($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "7");
		$this->db->where("den", "ponedelnik");
        return $this->db->get("meni");;
	}
	
	//zema meni8 za ponedelnik
	public function get_meni8_ponedelnik($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "8");
		$this->db->where("den", "ponedelnik");
        return $this->db->get("meni");;
	}
	
	//zema meni9 za ponedelnik
	public function get_meni9_ponedelnik($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "9");
		$this->db->where("den", "ponedelnik");
        return $this->db->get("meni");;
	}
	
	//zema meni10 za ponedelnik
	public function get_meni10_ponedelnik($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "10");
		$this->db->where("den", "ponedelnik");
        return $this->db->get("meni");;
	}
	
	//zema meni1 za vtornik
	public function get_meni1_vtornik($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "1");
		$this->db->where("den", "vtornik");
        return $this->db->get("meni");
	}
	
	//zema meni2 za vtornik
	public function get_meni2_vtornik($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "2");
		$this->db->where("den", "vtornik");
        return $this->db->get("meni");;
	}
	
	//zema meni3 za vtornik
	public function get_meni3_vtornik($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "3");
		$this->db->where("den", "vtornik");
        return $this->db->get("meni");;
	}
	
	//zema meni4 za vtornik
	public function get_meni4_vtornik($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "4");
		$this->db->where("den", "vtornik");
        return $this->db->get("meni");;
	}
	
	//zema meni5 za vtornik
	public function get_meni5_vtornik($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "5");
		$this->db->where("den", "vtornik");
        return $this->db->get("meni");;
	}
	
	//zema meni6 za vtornik
	public function get_meni6_vtornik($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "6");
		$this->db->where("den", "vtornik");
        return $this->db->get("meni");;
	}
	
	//zema meni7 za vtornik
	public function get_meni7_vtornik($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "7");
		$this->db->where("den", "vtornik");
        return $this->db->get("meni");;
	}
	
	//zema meni8 za vtornik
	public function get_meni8_vtornik($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "8");
		$this->db->where("den", "vtornik");
        return $this->db->get("meni");;
	}
	
	//zema meni9 za vtornik
	public function get_meni9_vtornik($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "9");
		$this->db->where("den", "vtornik");
        return $this->db->get("meni");
	}
	
	//zema meni10 za vtornik
	public function get_meni10_vtornik($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "10");
		$this->db->where("den", "vtornik");
        return $this->db->get("meni");
	}
	
	//zema meni1 za sreda
	public function get_meni1_sreda($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "1");
		$this->db->where("den", "sreda");
        return $this->db->get("meni");
	}
	
	//zema meni2 za sreda
	public function get_meni2_sreda($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "2");
		$this->db->where("den", "sreda");
        return $this->db->get("meni");
	}
	
	//zema meni3 za sreda
	public function get_meni3_sreda($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "3");
		$this->db->where("den", "sreda");
        return $this->db->get("meni");
	}
	
	//zema meni4 za sreda
	public function get_meni4_sreda($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "4");
		$this->db->where("den", "sreda");
        return $this->db->get("meni");
	}
	
	//zema meni5 za sreda
	public function get_meni5_sreda($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "5");
		$this->db->where("den", "sreda");
        return $this->db->get("meni");;
	}
	
	//zema meni6 za sreda
	public function get_meni6_sreda($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "6");
		$this->db->where("den", "sreda");
        return $this->db->get("meni");
	}
	
	//zema meni7 za sreda
	public function get_meni7_sreda($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "7");
		$this->db->where("den", "sreda");
        return $this->db->get("meni");
	}
	
	//zema meni8 za sreda
	public function get_meni8_sreda($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "8");
		$this->db->where("den", "sreda");
        return $this->db->get("meni");
	}
	
	//zema meni9 za sreda
	public function get_meni9_sreda($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "9");
		$this->db->where("den", "sreda");
        return $this->db->get("meni");
	}
	
	//zema meni10 za sreda
	public function get_meni10_sreda($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "10");
		$this->db->where("den", "sreda");
        return $this->db->get("meni");
	}
	
	//zema meni1 za cetvrtok
	public function get_meni1_cetvrtok($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "1");
		$this->db->where("den", "cetvrtok");
        return $this->db->get("meni");
	}
	
	//zema meni2 za cetvrtok
	public function get_meni2_cetvrtok($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "2");
		$this->db->where("den", "cetvrtok");
        return $this->db->get("meni");
	}
	
	//zema meni3 za cetvrtok
	public function get_meni3_cetvrtok($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "3");
		$this->db->where("den", "cetvrtok");
        return $this->db->get("meni");
	}
	
	//zema meni4 za cetvrtok
	public function get_meni4_cetvrtok($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "4");
		$this->db->where("den", "cetvrtok");
        return $this->db->get("meni");
	}
	
	//zema meni5 za cetvrtok
	public function get_meni5_cetvrtok($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "5");
		$this->db->where("den", "cetvrtok");
        return $this->db->get("meni");
	}
	
	//zema meni6 za cetvrtok
	public function get_meni6_cetvrtok($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "6");
		$this->db->where("den", "cetvrtok");
        return $this->db->get("meni");
	}
	
	//zema meni7 za cetvrtok
	public function get_meni7_cetvrtok($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "7");
		$this->db->where("den", "cetvrtok");
        return $this->db->get("meni");
	}
	
	//zema meni8 za cetvrtok
	public function get_meni8_cetvrtok($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "8");
		$this->db->where("den", "cetvrtok");
        return $this->db->get("meni");
	}
	
	//zema meni9 za cetvrtok
	public function get_meni9_cetvrtok($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "9");
		$this->db->where("den", "cetvrtok");
        return $this->db->get("meni");
	}
	
	//zema meni10 za cetvrtok
	public function get_meni10_cetvrtok($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "10");
		$this->db->where("den", "cetvrtok");
        return $this->db->get("meni");
	}
	
	//zema meni1 za petok
	public function get_meni1_petok($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "1");
		$this->db->where("den", "petok");
        return $this->db->get("meni");
	}
	
	//zema meni2 za petok
	public function get_meni2_petok($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "2");
		$this->db->where("den", "petok");
        return $this->db->get("meni");
	}
	
	//zema meni3 za petok
	public function get_meni3_petok($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "3");
		$this->db->where("den", "petok");
        return $this->db->get("meni");
	}
	
	//zema meni4 za petok
	public function get_meni4_petok($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "4");
		$this->db->where("den", "petok");
        return $this->db->get("meni");
	}
	
	//zema meni5 za petok
	public function get_meni5_petok($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "5");
		$this->db->where("den", "petok");
        return $this->db->get("meni");;
	}
	
	//zema meni6 za petok
	public function get_meni6_petok($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "6");
		$this->db->where("den", "petok");
        return $this->db->get("meni");
	}
	
	//zema meni7 za petok
	public function get_meni7_petok($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "7");
		$this->db->where("den", "petok");
        return $this->db->get("meni");
	}
	
	//zema meni8 za petok
	public function get_meni8_petok($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "8");
		$this->db->where("den", "petok");
        return $this->db->get("meni");
	}
	
	//zema meni9 za petok
	public function get_meni9_petok($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "9");
		$this->db->where("den", "petok");
        return $this->db->get("meni");
	}
	
	//zema meni10 za petok
	public function get_meni10_petok($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "10");
		$this->db->where("den", "petok");
        return $this->db->get("meni");
	}
	
	//zema meni1 za sabota
	public function get_meni1_sabota($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "1");
		$this->db->where("den", "sabota");
        return $this->db->get("meni");
	}
	
	//zema meni2 za sabota
	public function get_meni2_sabota($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "2");
		$this->db->where("den", "sabota");
        return $this->db->get("meni");
	}
	
	//zema meni3 za sabota
	public function get_meni3_sabota($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "3");
		$this->db->where("den", "sabota");
        return $this->db->get("meni");
	}
	
	//zema meni4 za sabota
	public function get_meni4_sabota($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "4");
		$this->db->where("den", "sabota");
        return $this->db->get("meni");
	}
	
	//zema meni5 za sabota
	public function get_meni5_sabota($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "5");
		$this->db->where("den", "sabota");
        return $this->db->get("meni");;
	}
	
	//zema meni6 za sabota
	public function get_meni6_sabota($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "6");
		$this->db->where("den", "sabota");
        return $this->db->get("meni");
	}
	
	//zema meni7 za sabota
	public function get_meni7_sabota($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "7");
		$this->db->where("den", "sabota");
        return $this->db->get("meni");
	}
	
	//zema meni8 za sabota
	public function get_meni8_sabota($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "8");
		$this->db->where("den", "sabota");
        return $this->db->get("meni");
	}
	
	//zema meni9 za sabota
	public function get_meni9_sabota($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "9");
		$this->db->where("den", "sabota");
        return $this->db->get("meni");
	}
	
	//zema meni10 za sabota
	public function get_meni10_sabota($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "10");
		$this->db->where("den", "sabota");
        return $this->db->get("meni");
	}
	
	//zema meni1 za nedela
	public function get_meni1_nedela($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "1");
		$this->db->where("den", "nedela");
        return $this->db->get("meni");
	}
	
	//zema meni2 za nedela
	public function get_meni2_nedela($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "2");
		$this->db->where("den", "nedela");
        return $this->db->get("meni");
	}
	
	//zema meni3 za nedela
	public function get_meni3_nedela($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "3");
		$this->db->where("den", "nedela");
        return $this->db->get("meni");
	}
	
	//zema meni4 za nedela
	public function get_meni4_nedela($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "4");
		$this->db->where("den", "nedela");
        return $this->db->get("meni");
	}
	
	//zema meni5 za nedela
	public function get_meni5_nedela($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "5");
		$this->db->where("den", "nedela");
        return $this->db->get("meni");;
	}
	
	//zema meni6 za nedela
	public function get_meni6_nedela($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "6");
		$this->db->where("den", "nedela");
        return $this->db->get("meni");
	}
	
	//zema meni7 za nedela
	public function get_meni7_nedela($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "7");
		$this->db->where("den", "nedela");
        return $this->db->get("meni");
	}
	
	//zema meni8 za nedela
	public function get_meni8_nedela($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "8");
		$this->db->where("den", "nedela");
        return $this->db->get("meni");
	}
	
	//zema meni9 za nedela
	public function get_meni9_nedela($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "9");
		$this->db->where("den", "nedela");
        return $this->db->get("meni");
	}
	
	//zema meni10 za nedela
	public function get_meni10_nedela($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "10");
		$this->db->where("den", "nedela");
        return $this->db->get("meni");
	}
	
	//prijavuvanje smena
	 public function prijavuvanje_smena($korisnik_id, $datum, $time)
	 {
		 $dataTime = array(
                "korisnik_id"   => $korisnik_id,
				"datum" => $datum,
                "smena_begin"   => $time
            );
			
		$this->db->insert('prijavuvanje_smena', $dataTime);
		
		if ($this->db->affected_rows())
			return TRUE;
		else
			return FALSE;
	 }
	 
	 //izvestaj vraboteni
	 public function izvestaj_vraboteni($startDate)
	 {
		$this->db->select("ime, prezime, kod_karticka, datum, smena_begin");
		$this->db->join("korisnici", "korisnici.id = prijavuvanje_smena.korisnik_id", "left");
		$this->db->where("datum", $startDate); 
		 $this->db->group_by("korisnici.id");
     //   return $this->db->get("prijavuvanje_smena");
		$query = $this->db->get("prijavuvanje_smena");
		return $query->result_array();
	 }
	
	//izvestaj na vraboteni od baza
	 public function izvestaj_vraboteni_baza()
	 {
		$this->db->select("ime, prezime, kod_karticka, personalen_broj, uloga, username, password");
		$query = $this->db->get("korisnici");
		return $query->result_array();
	 }
	
	//izvestaj na otsustva
	 public function izvestaj_otsustvo($startDate)
	 {
		$this->db->select("prezime, ime, datum_denovi_od, datum_denovi_do, tip_na_otsustvo");
		$this->db->join("korisnici", "korisnici.id = otsustvo.korisnik_id", "left");
		$this->db->where("datum_denovi_do >=", $startDate); 
		$query = $this->db->get("otsustvo");
		return $query->result_array();
	 }
	
	public function izvestaj_vraboteni_za_lista()
	 {
		$this->db->select("*");
		$query = $this->db->get("korisnici");
		
		return $query->result_array();
	 }
	 
	public function odbrano_meni_za_lista_user($user)
	{
		$currentDate = new DateTime($user['datum']);
		$startOfWeek = clone $currentDate;
		$startOfWeek->modify('this week');
		$startOfWeek->modify('Monday');
		$endOfWeek = clone $startOfWeek;
		$endOfWeek->modify('Sunday');
		
		$startOfWeekStr = $startOfWeek->format('Y-m-d H:i:s');
		$endOfWeekStr = $endOfWeek->format('Y-m-d H:i:s');
		
		$this->db->select("*");
		$this->db->where("korisnik_id", $user['id']);
		$this->db->where("do_datum >= '" . $startOfWeekStr . "'");
		$this->db->where("od_datum <= '" . $endOfWeekStr . "'");
		$odberenoQuery = $this->db->get("odbereno_meni");

		return $odberenoQuery->result_array();
	}
	 
	 //lista na naracki
	 public function lista_naracki($from_date,$to_date)
	 {
		$this->db->select("ime, prezime, kod_karticka, smena, lokacija, ponedelnik, vtornik, sreda, cetvrtok, petok, sabota");
		$this->db->join("smena", "smena.korisnik_id = korisnici.id", "left");
		$this->db->join("lokacija", "lokacija.korisnik_id = korisnici.id", "left");
		$this->db->join("odbereno_meni", "odbereno_meni.korisnik_id = korisnici.id", "left");
		$this->db->where("odbereno_meni.od_datum >= '" . $from_date . "'");
		$this->db->where("odbereno_meni.do_datum <= '" . $to_date . "'");
		$this->db->where("smena.od_datum >= '" . $from_date . "'");
		$this->db->where("smena.do_datum <= '" . $to_date . "'");
		$this->db->where("lokacija.od_datum >= '" . $from_date . "'");
		$this->db->where("lokacija.do_datum <= '" . $to_date . "'");
		$this->db->group_by("korisnici.id");
		$query = $this->db->get("korisnici");
		return $query->result_array();
	 }
	 
	 public function update_profile($data)
    {
        $this->db->where('id', $data['id']);
        $this->db->update('korisnici', $data);
    }
}