<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Index extends CI_Controller {

	public function __construct ()
	{
		parent::__construct ();
		date_default_timezone_set(DEFAULT_TIMEZONE);
		$this->load->model('home_model');
		$this->lang->load('app', DEFAULT_LANGUAGE);
	}

	private $data;

	/**
	 * Index Page for this controller.
	 *
	 */
	public function index()
	{
		$this->data['main_view'] = 'home/index';
		$this->template->load($this->data);
	}
	
	public function index_logout()
	{
		echo '<script>alert("Обидете се повторно или обратете се до вашиот супервизор.")</script>';
		$this->data['main_view'] = 'home/index';
		$this->template->load($this->data);
	}

	/**
	 * Check Login
	 *
	 */
	public function check_login()
	{
		$this->session->unset_userdata('logged_in');
		$this->session->unset_userdata('username');
		if(!$this->session->userdata('logged_in') && $this->input->post('username') && trim($this->input->post('username')) != DISABLED_ACCOUNT && $this->input->post('password')){ 
				$check = $this->home_model->check_login($this->input->post('username'), $this->input->post('password'));
				if ($check){
					$this->session->set_userdata('logged_in', 1);
					$this->session->set_userdata('username', $check);
				//	$this->home_model->update_last_access($check);
					redirect('admin/index');
				} 
		} elseif (!$this->session->userdata('logged_in') && $this->input->post('rfid_card') && trim($this->input->post('rfid_card')) != DISABLED_ACCOUNT){
				$check_rfid = $this->home_model->check_login_rfid($this->input->post('rfid_card'));
				if ($check_rfid){
					$this->session->set_userdata('logged_in', 2);
					$this->session->set_userdata('rfid_card', $check_rfid);
					redirect('admin/index');
				}
		}
		redirect('index/index_logout');
	}
	/**
	 * Check Login RFID Card (no use)
	 *
	 */
	public function check_login_rfid()
	{
		$this->session->unset_userdata('logged_in');
		$this->session->unset_userdata('rfid_card');
		if(!$this->session->userdata('logged_in') && $this->input->post('rfid_card') && trim($this->input->post('rfid_card')) != DISABLED_ACCOUNT ){ 
				$check_rfid = $this->home_model->check_login_rfid($this->input->post('rfid_card'));
				if ($check_rfid){
					$this->session->set_userdata('logged_in', 1);
					$this->session->set_userdata('rfid_card', $check_rfid);
				//	$this->home_model->update_last_access($check);
					redirect('admin/index');
				}
		}
		redirect('index/index_logout');
	}
}

/* End of file index.php */
/* Location: ./application/controllers/index.php */