<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class App_admin extends CI_Controller {

	public function __construct ()
	{
		parent::__construct ();
		date_default_timezone_set(DEFAULT_TIMEZONE);
		$this->load->model('home_model');

		$this->data['logged_in'] = FALSE;
		$this->data['rfid_card'] = FALSE;
		
		if ($this->session->userdata('last_actiity') && (time() - $this->session->userdata('last_actiity') > 1800))
			$this->session->unset_userdata('logged_in'); 
		$this->session->set_userdata('last_activity', time());

		if($this->session->userdata('logged_in') && $this->session->userdata('logged_in') == 2 $this->session->userdata('rfid_card') && trim($this->session->userdata('rfid_card')) != DISABLED_ACCOUNT){
			$this->data['logged_in'] = TRUE;
			$this->data['rfid_card'] = $this->session->userdata('rfid_card');
	    } else {
    	    redirect('index/index');
        	die();
	    }
	}

	private $data;

	/**
	 * Logout
	 *
	 */
	public function check_logout()
	{
		if($this->session->userdata('logged_in')){ 
			$this->session->unset_userdata('logged_in');
			redirect('index/index');		
		}
		redirect('index/index');
	}

	/**
	 * Index Page for this controller.
	 *
	 */
	public function index()
	{
		$this->data['client_data'] = $this->home_model->get_client($this->data['username']);
		$this->data['all_employees'] = $this->home_model->get_all_employees();
		
		if(($this->data['client_data']->row()->uloga == 'vraboten') && (date('N') < 5))
		{
			$this->data['sidebar_navigation'] = 'home';
			$this->data['breadcrumb_text'] = $this->lang->line('sidebar_menu_home');
			$this->data['breadcrumb_icon'] = 'icon-home';
			
			$korisnik_id = $this->data['client_data']->row()->id;
			$datum = date("Y-m-d");
			$smena_begin = date("h:i:sa");
			$this->home_model->prijavuvanje_smena($korisnik_id,$datum,$smena_begin);
			
			$this->data['main_view'] = 'admin/index_vraboten';
			$this->template->load($this->data);
		}
		else if($this->data['client_data']->row()->uloga == 'admin_fabrika')
		{
			$this->data['sidebar_navigation'] = 'home';
			$this->data['breadcrumb_text'] = $this->lang->line('sidebar_menu_home');
			$this->data['breadcrumb_icon'] = 'icon-home';

			$this->data['main_view'] = 'admin/index_fabrika';
			$this->template->load($this->data);
		}
		else if($this->data['client_data']->row()->uloga == 'admin_operator_hrana')
		{
			$this->data['sidebar_navigation'] = 'home';
			$this->data['breadcrumb_text'] = $this->lang->line('sidebar_menu_home');
			$this->data['breadcrumb_icon'] = 'icon-home';

			$this->data['main_view'] = 'admin/index_operator_hrana';
			$this->template->load($this->data);
		}
		else {
    	    redirect('index/index');
		}
	}

}

/* End of file app_admin.php */
/* Location: ./application/controllers/app_admin.php */