<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Admin extends CI_Controller {

	public function __construct ()
	{
		parent::__construct ();
		date_default_timezone_set(DEFAULT_TIMEZONE);
		$this->load->model('home_model');
		$this->load->library('excel');
		$this->data['logged_in'] = FALSE;
		$this->data['username'] = FALSE;
		$this->data['rfid_card'] = FALSE;
		$this->data['client_data'] = FALSE;

		if ($this->session->userdata('last_actiity') && (time() - $this->session->userdata('last_actiity') > 1800))
			$this->session->unset_userdata('logged_in'); 
		$this->session->set_userdata('last_activity', time());

		if($this->session->userdata('logged_in') && $this->session->userdata('logged_in') == 1 && $this->session->userdata('username') && trim($this->session->userdata('username')) != DISABLED_ACCOUNT){ 
			$this->data['logged_in'] = TRUE;
			$this->data['username'] = $this->session->userdata('username');
			$this->data['client_data'] = $this->home_model->get_client($this->data['username']);
	    } elseif($this->session->userdata('logged_in') && $this->session->userdata('logged_in') == 2 && $this->session->userdata('rfid_card') && trim($this->session->userdata('rfid_card')) != DISABLED_ACCOUNT){
			$this->data['logged_in'] = TRUE;
			$this->data['rfid_card'] = $this->session->userdata('rfid_card');
			$this->data['client_data'] = $this->home_model->get_client($this->data['rfid_card']);
		} else {
    	    redirect('index/index_logout');
        	die();
	    }

		if (!$this->data['client_data']->num_rows())
			redirect('index/index_logout');
		
        if (!isset($this->data['client_data']->row()->language) || !in_array($this->data['client_data']->row()->language, unserialize(AVAILABLE_LANGUAGES))) {
			$this->lang->load('app', DEFAULT_LANGUAGE);
			return;
		}
		
	}

	private $data;


	/**
	 * Logout
	 *
	 */
	public function check_logout()
	{
		if($this->session->userdata('logged_in')){ 
			$this->session->unset_userdata('logged_in');
			$this->session->unset_userdata('rfid_card');
			$this->session->unset_userdata('username');
			
			$this->data['logged_in'] = FALSE;
			$this->data['username'] = FALSE;
			$this->data['rfid_card'] = FALSE;
			$this->data['client_data'] = FALSE;
			redirect('index/index');		
		}
		redirect('index/index');
	}

	/**
	 * Index Page for this controller.
	 *
	 */
	public function index()
	{
		$this->data['all_employees'] = $this->home_model->get_all_employees();
		$next_week = strtotime('next week');
		$from_date = date("Y-m-d", strtotime('monday', $next_week));
		$to_date = date("Y-m-d", strtotime('sunday', $next_week));
		$tekovno_from_date = date("Y-m-d", strtotime('monday this week'));
		$tekovno_to_date = date("Y-m-d", strtotime('sunday this week'));

		$this->data['from_date'] = ltrim($from_date, '-');
		$this->data['to_date'] = ltrim($to_date, '-');
		$this->data['tekovno_from_date'] = ltrim($tekovno_from_date, '-');
		$this->data['tekovno_to_date'] = ltrim($tekovno_to_date, '-');
		
		$korisnik_id = $this->data['client_data']->row()->id;
		$datum = date("Y-m-d");
		$smena_begin = date("h:i:sa");
		
		$this->data['role'] = $this->data['client_data']->row()->uloga;
		
		if (!$this->data['client_data']->row()->uloga == 'admin_operator_hrana') {
			$this->home_model->prijavuvanje_smena($korisnik_id,$datum,$smena_begin);
		}

		if(($this->data['client_data']->row()->uloga == 'vraboten')) {
			$this->data['smena'] = $this->home_model->odbrana_smena($korisnik_id,$from_date,$to_date);
			$this->data['lokacija'] = $this->home_model->odbrana_lokacija($korisnik_id,$from_date,$to_date);
			$this->data['meni'] = $this->home_model->odbrano_meni($korisnik_id,$from_date,$to_date);
			
			$this->data['tekovna_smena'] = $this->home_model->odbrana_smena($korisnik_id,$tekovno_from_date,$tekovno_to_date);
			$this->data['tekovna_lokacija'] = $this->home_model->odbrana_lokacija($korisnik_id,$tekovno_from_date,$tekovno_to_date);
			$this->data['tekovno_meni'] = $this->home_model->odbrano_meni($korisnik_id,$tekovno_from_date,$tekovno_to_date);
			
			if ($this->data['smena']->result() && $this->data['meni']->result()) {
				$this->data['sidebar_navigation'] = 'home';
				$this->data['breadcrumb_text'] = $this->lang->line('sidebar_menu_home');
				$this->data['breadcrumb_icon'] = 'icon-home';
				
				$this->data['main_view'] = 'admin/index_vraboten';
				$this->template->load($this->data);
				return;
			}
			
			//if ((date('N') >= 5)) {
			//	redirect('index/index_logout');
			//}
			
			$this->data['sidebar_navigation'] = 'izbor_smena';
			$this->data['breadcrumb_text'] = $this->lang->line('sidebar_menu_izbor_na_smena');
			$this->data['breadcrumb_icon'] = 'icon-people';
			$this->data['izbor_smena_header'] = $this->lang->line('sidebar_menu_izbor_na_smena');
			$this->data['izbor_smena_header_icon'] = 'icon-people';
			$this->data['main_view'] = 'admin/izbor_smena';
			$this->template->load($this->data);
			return;
		}
		
		$this->data['sidebar_navigation'] = 'home';
		$this->data['breadcrumb_text'] = $this->lang->line('sidebar_menu_home');
		$this->data['breadcrumb_icon'] = 'icon-home';
		$this->data['main_view'] = 'admin/index_admin';
		
		$this->template->load($this->data);
	}
	
	/**
	 * Izbor na smena
	 *
	 */
	public function izbor_smena()
	{
		if($this->session->userdata('username')){
			$this->data['client_data'] = $this->home_model->get_client($this->data['username']);
		}
		elseif($this->session->userdata('rfid_card')) {
			$this->data['client_data'] = $this->home_model->get_client($this->data['rfid_card']);
		}
		$next_week = strtotime('next week');
		$from_date = date("Y-m-d", strtotime('monday', $next_week));
		$to_date = date("Y-m-d", strtotime('sunday', $next_week));

		// Remove leading '--' from date strings
		$this->data['from_date'] = ltrim($from_date, '-');
		$this->data['to_date'] = ltrim($to_date, '-');
	
		$this->data['sidebar_navigation'] = 'izbor_smena';
		$this->data['breadcrumb_text'] = $this->lang->line('sidebar_menu_izbor_na_smena');
		$this->data['breadcrumb_icon'] = 'icon-people';
		$this->data['izbor_smena_header'] = $this->lang->line('sidebar_menu_izbor_na_smena');
		$this->data['izbor_smena_header_icon'] = 'icon-people';

		$this->data['main_view'] = 'admin/izbor_smena';
		$this->template->load($this->data);
	}
	
	/**
	 * Izbor na lokacija
	 *
	 */
	public function izbor_lokacija()
	{
		if($this->session->userdata('username')){
			$this->data['client_data'] = $this->home_model->get_client($this->data['username']);
		}
		elseif($this->session->userdata('rfid_card')) {
			$this->data['client_data'] = $this->home_model->get_client($this->data['rfid_card']);
		}
		$next_week = strtotime('next week');
		$from_date = date("Y-m-d", strtotime('monday', $next_week));
		$to_date = date("Y-m-d", strtotime('sunday', $next_week));

		// Remove leading '--' from date strings
		$this->data['from_date'] = ltrim($from_date, '-');
		$this->data['to_date'] = ltrim($to_date, '-');
	
		$this->data['sidebar_navigation'] = 'izbor_lokacija';
		$this->data['breadcrumb_text'] = $this->lang->line('sidebar_menu_izbor_na_lokacija');
		$this->data['breadcrumb_icon'] = 'icon-people';
		$this->data['izbor_lokacija_header'] = $this->lang->line('sidebar_menu_izbor_na_lokacija');
		$this->data['izbor_lokacija_header_icon'] = 'icon-people';

		$this->data['main_view'] = 'admin/izbor_lokacija';
		$this->template->load($this->data);
	}
	
	/**
	 * Zema id za korisnik
	 *
	 */
	public function get_korisnik()
	{
		$ime = $this->input->post('ime');
		$prezime = $this->input->post('prezime');
		$result = $this->home_model->get_korisnik($ime, $prezime);
		
        echo(json_encode($result));
	}
	
	/**
	 * Zema smena za period
	 *
	 */
	public function proveri_smena_za_period()
	{
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$korisnik_id = $this->input->post('korisnik_id');
		$result = $this->home_model->proveri_smena_za_period($korisnik_id,$from_date,$to_date);
        echo(json_encode($result));
	}
	
	/**
	 * Zema lokacija za period
	 *
	 */
	public function proveri_lokacija_za_period()
	{
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$korisnik_id = $this->input->post('korisnik_id');
		$result = $this->home_model->proveri_lokacija_za_period($korisnik_id,$from_date,$to_date);
        echo(json_encode($result));
	}
	
	/**
	 * Zema meni za period
	 *
	 */
	public function proveri_meni_za_period()
	{
		$from_date = convert_date_db($this->input->post('from_date'));
		$to_date = convert_date_db($this->input->post('to_date'));
		$korisnik_id = $this->input->post('korisnik_id');
		$result = $this->home_model->proveri_meni_za_period($korisnik_id,$from_date,$to_date);
        echo(json_encode($result));
	}
	
	/**
	 * Brise smena za period
	 *
	 */
	public function izbrisi_smena_za_period()
	{
		$od_datum = $this->input->post('od_datum');
		$do_datum = $this->input->post('do_datum');
		$k_id = $this->input->post('k_id');
		$result = $this->home_model->izbrisi_smena_za_period($k_id,$od_datum,$do_datum);
        echo(json_encode($result));
	}
	
	/**
	 * Brise lokacija za period
	 *
	 */
	public function izbrisi_lokacija_za_period()
	{
		$od_datum = $this->input->post('od_datum');
		$do_datum = $this->input->post('do_datum');
		$k_id = $this->input->post('k_id');
		$result = $this->home_model->izbrisi_lokacija_za_period($k_id,$od_datum,$do_datum);
        echo(json_encode($result));
	}
	
	/**
	 * Brise meni za period
	 *
	 */
	public function izbrisi_meni_za_period()
	{
		$od_datum = $this->input->post('od_datum');
		$do_datum = $this->input->post('do_datum');
		$k_id = $this->input->post('k_id');
		$result = $this->home_model->izbrisi_meni_za_period($k_id,$od_datum,$do_datum);
        echo(json_encode($result));
	}
	
	/**
	 * Brise vraboten
	 *
	 */
	public function delete_employee()
	{
		$ime = $this->input->post('ime');
		$prezime = $this->input->post('prezime');
		$result = $this->home_model->delete_employee($ime, $prezime);
	}
	
	/**
	 * Insert na smena vo baza
	 *
	 */
	public function save_smena()
	{
		$smena = $this->input->post('smena');
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$korisnik_id = $this->input->post('korisnik_id');
		$result = $this->home_model->insert_smena($smena, $from_date, $to_date, $korisnik_id);
		
        echo(json_encode($result));
	}
	
	/**
	 * Insert na lokacija vo baza
	 *
	 */
	public function save_lokacija()
	{
		$lokacija = $this->input->post('lokacija');
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$korisnik_id = $this->input->post('korisnik_id');
		$result = $this->home_model->insert_lokacija($lokacija, $from_date, $to_date, $korisnik_id);
		
        echo(json_encode($result));
	}
	
	/**
	 * Zema meni za period
	 *
	 */
	public function get_meni()
	{
		$from_date = convert_date_db($this->input->post('from_date'));
		$to_date = convert_date_db($this->input->post('to_date'));
		$result = $this->home_model->get_meni($from_date,$to_date);
		echo(json_encode($result));
	}
	
	/**
	 * Insert na odbrano meni vo baza
	 *
	 */
	public function save_odbereno_meni()
	{
		$ponedelnik = $this->input->post('ponedelnik');
		$vtornik = $this->input->post('vtornik');
		$sreda = $this->input->post('sreda');
		$cetvrtok = $this->input->post('cetvrtok');
		$petok = $this->input->post('petok');
		$sabota = $this->input->post('sabota');
		$nedela = $this->input->post('nedela');
		$from_date = convert_date_db($this->input->post('from_date'));
		$to_date = convert_date_db($this->input->post('to_date'));
		$korisnik_id = $this->input->post('korisnik_id');
		
		$result = $this->home_model->insert_odbrano_meni($ponedelnik, $vtornik, $sreda, $cetvrtok, $petok, $sabota, $nedela, $from_date, $to_date, $korisnik_id);

        echo(json_encode($result));
	}
	
	public function save_odberena_smena()
	{
		$ponedelnik = $this->input->post('ponedelnik');
		$vtornik = $this->input->post('vtornik');
		$sreda = $this->input->post('sreda');
		$cetvrtok = $this->input->post('cetvrtok');
		$petok = $this->input->post('petok');
		$sabota = $this->input->post('sabota');
		$nedela = $this->input->post('nedela');
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$korisnik_id = $this->input->post('korisnik_id');
		
		$result = $this->home_model->insert_odberena_smena($ponedelnik, $vtornik, $sreda, $cetvrtok, $petok, $sabota, $nedela, $from_date, $to_date, $korisnik_id);

        echo(json_encode($result));
	}
	
	/**
	 * Izbor na meni
	 *
	 */
	public function izbor_meni()
	{
		if($this->session->userdata('username')){
			$this->data['client_data'] = $this->home_model->get_client($this->data['username']);
			$this->data['client_all_data'] = $this->home_model->get_all_data_client($this->data['username']);
		}
		elseif($this->session->userdata('rfid_card')) {
			$this->data['client_data'] = $this->home_model->get_client($this->data['rfid_card']);
			$this->data['client_all_data'] = $this->home_model->get_all_data_client($this->data['rfid_card']);
		}
		
		$next_week = strtotime('next week');
		$date_monday = date("d.m.Y", strtotime('monday', $next_week));
		$date_sunday = date("d.m.Y", strtotime('sunday', $next_week));
	
		$from_date = convert_date_db($date_monday);
		$to_date = convert_date_db($date_sunday);

		$date = date('Y/m/d');
		
		$start_date = strtotime($date);
		$this->data['start_date'] = date('Y-m-d H:i:s',$start_date);
		$this->data['from_date'] = $from_date;
		$startDate = date('Y-m-d H:i:s',$start_date);
		
		$end_date = strtotime($date);
		$this->data['end_date'] = date('Y-m-d H:i:s',$end_date);
		$this->data['to_date'] = $to_date;
		$endDate = date('Y-m-d H:i:s',$end_date);
		
		$this->data['meni_data'] = $this->home_model->get_meni($from_date,$to_date);
		
		$this->data['toplo_gotveno_jadenje_data_ponedelnik'] = $this->home_model->get_meni1_ponedelnik($from_date,$to_date);
		$this->data['ladno_gotveno_salati_data_ponedelnik'] = $this->home_model->get_meni2_ponedelnik($from_date,$to_date);
		$this->data['ladni_konzervirani_proizvodi_data_ponedelnik'] = $this->home_model->get_meni3_ponedelnik($from_date,$to_date);
		$this->data['bez_gluten_vege_data_ponedelnik'] = $this->home_model->get_meni4_ponedelnik($from_date,$to_date);
		$this->data['suv_obrok_1_data_ponedelnik'] = $this->home_model->get_meni5_ponedelnik($from_date,$to_date);
		$this->data['suv_obrok_2_data_ponedelnik'] = $this->home_model->get_meni6_ponedelnik($from_date,$to_date);
		$this->data['smuti_data_ponedelnik'] = $this->home_model->get_meni7_ponedelnik($from_date,$to_date);
		$this->data['posno_data_ponedelnik'] = $this->home_model->get_meni8_ponedelnik($from_date,$to_date);
		$this->data['tuna_data_ponedelnik'] = $this->home_model->get_meni9_ponedelnik($from_date,$to_date);
		$this->data['cezar_data_ponedelnik'] = $this->home_model->get_meni10_ponedelnik($from_date,$to_date);
		
		$this->data['toplo_gotveno_jadenje_data_vtornik'] = $this->home_model->get_meni1_vtornik($from_date,$to_date);
		$this->data['ladno_gotveno_salati_data_vtornik'] = $this->home_model->get_meni2_vtornik($from_date,$to_date);
		$this->data['ladni_konzervirani_proizvodi_data_vtornik'] = $this->home_model->get_meni3_vtornik($from_date,$to_date);
		$this->data['bez_gluten_vege_data_vtornik'] = $this->home_model->get_meni4_vtornik($from_date,$to_date);
		$this->data['suv_obrok_1_data_vtornik'] = $this->home_model->get_meni5_vtornik($from_date,$to_date);
		$this->data['suv_obrok_2_data_vtornik'] = $this->home_model->get_meni6_vtornik($from_date,$to_date);
		$this->data['smuti_data_vtornik'] = $this->home_model->get_meni7_vtornik($from_date,$to_date);
		$this->data['posno_data_vtornik'] = $this->home_model->get_meni8_vtornik($from_date,$to_date);
		$this->data['tuna_data_vtornik'] = $this->home_model->get_meni9_vtornik($from_date,$to_date);
		$this->data['cezar_data_vtornik'] = $this->home_model->get_meni10_vtornik($from_date,$to_date);
		
		$this->data['toplo_gotveno_jadenje_data_sreda'] = $this->home_model->get_meni1_sreda($from_date,$to_date);
		$this->data['ladno_gotveno_salati_data_sreda'] = $this->home_model->get_meni2_sreda($from_date,$to_date);
		$this->data['ladni_konzervirani_proizvodi_data_sreda'] = $this->home_model->get_meni3_sreda($from_date,$to_date);
		$this->data['bez_gluten_vege_data_sreda'] = $this->home_model->get_meni4_sreda($from_date,$to_date);
		$this->data['suv_obrok_1_data_sreda'] = $this->home_model->get_meni5_sreda($from_date,$to_date);
		$this->data['suv_obrok_2_data_sreda'] = $this->home_model->get_meni6_sreda($from_date,$to_date);
		$this->data['smuti_data_sreda'] = $this->home_model->get_meni7_sreda($from_date,$to_date);
		$this->data['posno_data_sreda'] = $this->home_model->get_meni8_sreda($from_date,$to_date);
		$this->data['tuna_data_sreda'] = $this->home_model->get_meni9_sreda($from_date,$to_date);
		$this->data['cezar_data_sreda'] = $this->home_model->get_meni10_sreda($from_date,$to_date);
		
		$this->data['toplo_gotveno_jadenje_data_cetvrtok'] = $this->home_model->get_meni1_cetvrtok($from_date,$to_date);
		$this->data['ladno_gotveno_salati_data_cetvrtok'] = $this->home_model->get_meni2_cetvrtok($from_date,$to_date);
		$this->data['ladni_konzervirani_proizvodi_data_cetvrtok'] = $this->home_model->get_meni3_cetvrtok($from_date,$to_date);
		$this->data['bez_gluten_vege_data_cetvrtok'] = $this->home_model->get_meni4_cetvrtok($from_date,$to_date);
		$this->data['suv_obrok_1_data_cetvrtok'] = $this->home_model->get_meni5_cetvrtok($from_date,$to_date);
		$this->data['suv_obrok_2_data_cetvrtok'] = $this->home_model->get_meni6_cetvrtok($from_date,$to_date);
		$this->data['smuti_data_cetvrtok'] = $this->home_model->get_meni7_cetvrtok($from_date,$to_date);
		$this->data['posno_data_cetvrtok'] = $this->home_model->get_meni8_cetvrtok($from_date,$to_date);
		$this->data['tuna_data_cetvrtok'] = $this->home_model->get_meni9_cetvrtok($from_date,$to_date);
		$this->data['cezar_data_cetvrtok'] = $this->home_model->get_meni10_cetvrtok($from_date,$to_date);
	
		$this->data['toplo_gotveno_jadenje_data_petok'] = $this->home_model->get_meni1_petok($from_date,$to_date);
		$this->data['ladno_gotveno_salati_data_petok'] = $this->home_model->get_meni2_petok($from_date,$to_date);
		$this->data['ladni_konzervirani_proizvodi_data_petok'] = $this->home_model->get_meni3_petok($from_date,$to_date);
		$this->data['bez_gluten_vege_data_petok'] = $this->home_model->get_meni4_petok($from_date,$to_date);
		$this->data['suv_obrok_1_data_petok'] = $this->home_model->get_meni5_petok($from_date,$to_date);
		$this->data['suv_obrok_2_data_petok'] = $this->home_model->get_meni6_petok($from_date,$to_date);
		$this->data['smuti_data_petok'] = $this->home_model->get_meni7_petok($from_date,$to_date);
		$this->data['posno_data_petok'] = $this->home_model->get_meni8_petok($from_date,$to_date);
		$this->data['tuna_data_petok'] = $this->home_model->get_meni9_petok($from_date,$to_date);
		$this->data['cezar_data_petok'] = $this->home_model->get_meni10_petok($from_date,$to_date);
		
		$this->data['toplo_gotveno_jadenje_data_sabota'] = $this->home_model->get_meni1_sabota($from_date,$to_date);
		$this->data['ladno_gotveno_salati_data_sabota'] = $this->home_model->get_meni2_sabota($from_date,$to_date);
		$this->data['ladni_konzervirani_proizvodi_data_sabota'] = $this->home_model->get_meni3_sabota($from_date,$to_date);
		$this->data['bez_gluten_vege_data_sabota'] = $this->home_model->get_meni4_sabota($from_date,$to_date);
		$this->data['suv_obrok_1_data_sabota'] = $this->home_model->get_meni5_sabota($from_date,$to_date);
		$this->data['suv_obrok_2_data_sabota'] = $this->home_model->get_meni6_sabota($from_date,$to_date);
		$this->data['smuti_data_sabota'] = $this->home_model->get_meni7_sabota($from_date,$to_date);
		$this->data['posno_data_sabota'] = $this->home_model->get_meni8_sabota($from_date,$to_date);
		$this->data['tuna_data_sabota'] = $this->home_model->get_meni9_sabota($from_date,$to_date);
		$this->data['cezar_data_sabota'] = $this->home_model->get_meni10_sabota($from_date,$to_date);
		
		$this->data['toplo_gotveno_jadenje_data_nedela'] = $this->home_model->get_meni1_nedela($from_date,$to_date);
		$this->data['ladno_gotveno_salati_data_nedela'] = $this->home_model->get_meni2_nedela($from_date,$to_date);
		$this->data['ladni_konzervirani_proizvodi_data_nedela'] = $this->home_model->get_meni3_nedela($from_date,$to_date);
		$this->data['bez_gluten_vege_data_nedela'] = $this->home_model->get_meni4_nedela($from_date,$to_date);
		$this->data['suv_obrok_1_data_nedela'] = $this->home_model->get_meni5_nedela($from_date,$to_date);
		$this->data['suv_obrok_2_data_nedela'] = $this->home_model->get_meni6_nedela($from_date,$to_date);
		$this->data['smuti_data_nedela'] = $this->home_model->get_meni7_nedela($from_date,$to_date);
		$this->data['posno_data_nedela'] = $this->home_model->get_meni8_nedela($from_date,$to_date);
		$this->data['tuna_data_nedela'] = $this->home_model->get_meni9_nedela($from_date,$to_date);
		$this->data['cezar_data_nedela'] = $this->home_model->get_meni10_nedela($from_date,$to_date);

		$this->data['sidebar_navigation'] = 'izbor_meni';
		$this->data['breadcrumb_text'] = $this->lang->line('sidebar_menu_izbor_na_meni');
		$this->data['breadcrumb_icon'] = 'icon-book-open';
		$this->data['izbor_meni_header'] = $this->lang->line('sidebar_menu_izbor_na_meni');
		$this->data['izbor_meni_header_icon'] = 'icon-book-open';

		$this->data['main_view'] = 'admin/izbor_meni';
		$this->template->load($this->data);
	}
	
			/**
	 * Izbor na meni
	 *
	 */
	public function izbor_meni_admin()
	{
		if($this->session->userdata('username')){
			$this->data['client_data'] = $this->home_model->get_client($this->data['username']);
			$this->data['client_all_data'] = $this->home_model->get_all_data_client($this->data['username']);
		}
		elseif($this->session->userdata('rfid_card')) {
			$this->data['client_data'] = $this->home_model->get_client($this->data['rfid_card']);
			$this->data['client_all_data'] = $this->home_model->get_all_data_client($this->data['rfid_card']);
		}
		
		$next_week = strtotime('next week');
		$date_monday = date("d.m.Y", strtotime('monday', $next_week));
		$date_sunday = date("d.m.Y", strtotime('sunday', $next_week));
	
		$from_date = convert_date_db($date_monday);
		$to_date = convert_date_db($date_sunday);

		$date = date('Y/m/d');
		
		$start_date = strtotime($date);
		$this->data['start_date'] = date('Y-m-d H:i:s',$start_date);
		$this->data['from_date'] = $from_date;
		$startDate = date('Y-m-d H:i:s',$start_date);
		
		$end_date = strtotime($date);
		$this->data['end_date'] = date('Y-m-d H:i:s',$end_date);
		$this->data['to_date'] = $to_date;
		$endDate = date('Y-m-d H:i:s',$end_date);
				  		
		$this->data['meni_data'] = $this->home_model->get_meni($from_date,$to_date);
		
		$this->data['toplo_gotveno_jadenje_data_ponedelnik'] = $this->home_model->get_meni1_ponedelnik($from_date,$to_date);
		$this->data['ladno_gotveno_salati_data_ponedelnik'] = $this->home_model->get_meni2_ponedelnik($from_date,$to_date);
		$this->data['ladni_konzervirani_proizvodi_data_ponedelnik'] = $this->home_model->get_meni3_ponedelnik($from_date,$to_date);
		$this->data['bez_gluten_vege_data_ponedelnik'] = $this->home_model->get_meni4_ponedelnik($from_date,$to_date);
		$this->data['suv_obrok_1_data_ponedelnik'] = $this->home_model->get_meni5_ponedelnik($from_date,$to_date);
		$this->data['suv_obrok_2_data_ponedelnik'] = $this->home_model->get_meni6_ponedelnik($from_date,$to_date);
		$this->data['smuti_data_ponedelnik'] = $this->home_model->get_meni7_ponedelnik($from_date,$to_date);
		$this->data['posno_data_ponedelnik'] = $this->home_model->get_meni8_ponedelnik($from_date,$to_date);
		$this->data['tuna_data_ponedelnik'] = $this->home_model->get_meni9_ponedelnik($from_date,$to_date);
		$this->data['cezar_data_ponedelnik'] = $this->home_model->get_meni10_ponedelnik($from_date,$to_date);
		
		$this->data['toplo_gotveno_jadenje_data_vtornik'] = $this->home_model->get_meni1_vtornik($from_date,$to_date);
		$this->data['ladno_gotveno_salati_data_vtornik'] = $this->home_model->get_meni2_vtornik($from_date,$to_date);
		$this->data['ladni_konzervirani_proizvodi_data_vtornik'] = $this->home_model->get_meni3_vtornik($from_date,$to_date);
		$this->data['bez_gluten_vege_data_vtornik'] = $this->home_model->get_meni4_vtornik($from_date,$to_date);
		$this->data['suv_obrok_1_data_vtornik'] = $this->home_model->get_meni5_vtornik($from_date,$to_date);
		$this->data['suv_obrok_2_data_vtornik'] = $this->home_model->get_meni6_vtornik($from_date,$to_date);
		$this->data['smuti_data_vtornik'] = $this->home_model->get_meni7_vtornik($from_date,$to_date);
		$this->data['posno_data_vtornik'] = $this->home_model->get_meni8_vtornik($from_date,$to_date);
		$this->data['tuna_data_vtornik'] = $this->home_model->get_meni9_vtornik($from_date,$to_date);
		$this->data['cezar_data_vtornik'] = $this->home_model->get_meni10_vtornik($from_date,$to_date);
		
		$this->data['toplo_gotveno_jadenje_data_sreda'] = $this->home_model->get_meni1_sreda($from_date,$to_date);
		$this->data['ladno_gotveno_salati_data_sreda'] = $this->home_model->get_meni2_sreda($from_date,$to_date);
		$this->data['ladni_konzervirani_proizvodi_data_sreda'] = $this->home_model->get_meni3_sreda($from_date,$to_date);
		$this->data['bez_gluten_vege_data_sreda'] = $this->home_model->get_meni4_sreda($from_date,$to_date);
		$this->data['suv_obrok_1_data_sreda'] = $this->home_model->get_meni5_sreda($from_date,$to_date);
		$this->data['suv_obrok_2_data_sreda'] = $this->home_model->get_meni6_sreda($from_date,$to_date);
		$this->data['smuti_data_sreda'] = $this->home_model->get_meni7_sreda($from_date,$to_date);
		$this->data['posno_data_sreda'] = $this->home_model->get_meni8_sreda($from_date,$to_date);
		$this->data['tuna_data_sreda'] = $this->home_model->get_meni9_sreda($from_date,$to_date);
		$this->data['cezar_data_sreda'] = $this->home_model->get_meni10_sreda($from_date,$to_date);
		
		$this->data['toplo_gotveno_jadenje_data_cetvrtok'] = $this->home_model->get_meni1_cetvrtok($from_date,$to_date);
		$this->data['ladno_gotveno_salati_data_cetvrtok'] = $this->home_model->get_meni2_cetvrtok($from_date,$to_date);
		$this->data['ladni_konzervirani_proizvodi_data_cetvrtok'] = $this->home_model->get_meni3_cetvrtok($from_date,$to_date);
		$this->data['bez_gluten_vege_data_cetvrtok'] = $this->home_model->get_meni4_cetvrtok($from_date,$to_date);
		$this->data['suv_obrok_1_data_cetvrtok'] = $this->home_model->get_meni5_cetvrtok($from_date,$to_date);
		$this->data['suv_obrok_2_data_cetvrtok'] = $this->home_model->get_meni6_cetvrtok($from_date,$to_date);
		$this->data['smuti_data_cetvrtok'] = $this->home_model->get_meni7_cetvrtok($from_date,$to_date);
		$this->data['posno_data_cetvrtok'] = $this->home_model->get_meni8_cetvrtok($from_date,$to_date);
		$this->data['tuna_data_cetvrtok'] = $this->home_model->get_meni9_cetvrtok($from_date,$to_date);
		$this->data['cezar_data_cetvrtok'] = $this->home_model->get_meni10_cetvrtok($from_date,$to_date);
	
		$this->data['toplo_gotveno_jadenje_data_petok'] = $this->home_model->get_meni1_petok($from_date,$to_date);
		$this->data['ladno_gotveno_salati_data_petok'] = $this->home_model->get_meni2_petok($from_date,$to_date);
		$this->data['ladni_konzervirani_proizvodi_data_petok'] = $this->home_model->get_meni3_petok($from_date,$to_date);
		$this->data['bez_gluten_vege_data_petok'] = $this->home_model->get_meni4_petok($from_date,$to_date);
		$this->data['suv_obrok_1_data_petok'] = $this->home_model->get_meni5_petok($from_date,$to_date);
		$this->data['suv_obrok_2_data_petok'] = $this->home_model->get_meni6_petok($from_date,$to_date);
		$this->data['smuti_data_petok'] = $this->home_model->get_meni7_petok($from_date,$to_date);
		$this->data['posno_data_petok'] = $this->home_model->get_meni8_petok($from_date,$to_date);
		$this->data['tuna_data_petok'] = $this->home_model->get_meni9_petok($from_date,$to_date);
		$this->data['cezar_data_petok'] = $this->home_model->get_meni10_petok($from_date,$to_date);
		
		$this->data['toplo_gotveno_jadenje_data_sabota'] = $this->home_model->get_meni1_sabota($from_date,$to_date);
		$this->data['ladno_gotveno_salati_data_sabota'] = $this->home_model->get_meni2_sabota($from_date,$to_date);
		$this->data['ladni_konzervirani_proizvodi_data_sabota'] = $this->home_model->get_meni3_sabota($from_date,$to_date);
		$this->data['bez_gluten_vege_data_sabota'] = $this->home_model->get_meni4_sabota($from_date,$to_date);
		$this->data['suv_obrok_1_data_sabota'] = $this->home_model->get_meni5_sabota($from_date,$to_date);
		$this->data['suv_obrok_2_data_sabota'] = $this->home_model->get_meni6_sabota($from_date,$to_date);
		$this->data['smuti_data_sabota'] = $this->home_model->get_meni7_sabota($from_date,$to_date);
		$this->data['posno_data_sabota'] = $this->home_model->get_meni8_sabota($from_date,$to_date);
		$this->data['tuna_data_sabota'] = $this->home_model->get_meni9_sabota($from_date,$to_date);
		$this->data['cezar_data_sabota'] = $this->home_model->get_meni10_sabota($from_date,$to_date);
		
		$this->data['toplo_gotveno_jadenje_data_nedela'] = $this->home_model->get_meni1_nedela($from_date,$to_date);
		$this->data['ladno_gotveno_salati_data_nedela'] = $this->home_model->get_meni2_nedela($from_date,$to_date);
		$this->data['ladni_konzervirani_proizvodi_data_nedela'] = $this->home_model->get_meni3_nedela($from_date,$to_date);
		$this->data['bez_gluten_vege_data_nedela'] = $this->home_model->get_meni4_nedela($from_date,$to_date);
		$this->data['suv_obrok_1_data_nedela'] = $this->home_model->get_meni5_nedela($from_date,$to_date);
		$this->data['suv_obrok_2_data_nedela'] = $this->home_model->get_meni6_nedela($from_date,$to_date);
		$this->data['smuti_data_nedela'] = $this->home_model->get_meni7_nedela($from_date,$to_date);
		$this->data['posno_data_nedela'] = $this->home_model->get_meni8_nedela($from_date,$to_date);
		$this->data['tuna_data_nedela'] = $this->home_model->get_meni9_nedela($from_date,$to_date);
		$this->data['cezar_data_nedela'] = $this->home_model->get_meni10_nedela($from_date,$to_date);

		$this->data['sidebar_navigation'] = 'izbor_meni';
		$this->data['breadcrumb_text'] = $this->lang->line('sidebar_menu_izbor_na_meni');
		$this->data['breadcrumb_icon'] = 'icon-book-open';
		$this->data['izbor_meni_header'] = $this->lang->line('sidebar_menu_izbor_na_meni');
		$this->data['izbor_meni_header_icon'] = 'icon-book-open';
		$this->data['role'] = $this->data['client_data']->row()->uloga;

		$this->data['main_view'] = 'admin/izbor_meni_admin';
		$this->template->load($this->data);
	}
	
	/**
	 * Nov vraboten
	 *
	 */
	public function nov_vraboten()
	{
		if ($this->input->post('insert') && $this->input->post('novo_ime') && $this->input->post('novo_prezime') && $this->input->post('uloga') && $this->input->post('korisnicko_ime') && $this->input->post('lozinka')){
			$novo_ime = $this->input->post('novo_ime');
			$novo_prezime = $this->input->post('novo_prezime');
			$kod_karticka = $this->input->post('kod_karticka');
			$uloga = $this->input->post('uloga');
			$korisnicko_ime = $this->input->post('korisnicko_ime');
			$lozinka = $this->input->post('lozinka');
			
			if($this->home_model->nov_vraboten($novo_ime, $novo_prezime, $kod_karticka, $uloga, $korisnicko_ime, $lozinka))
			{
				$this->data['msg_pass_success'] = TRUE;
			}
			else
			{
				$this->data['msg_pass_error'] = TRUE;
			}
		}
		$this->data['sidebar_navigation'] = 'nov_vraboten';
		$this->data['breadcrumb_text'] = $this->lang->line('sidebar_menu_vnesuvanje_na_vraboten');
		$this->data['breadcrumb_icon'] = ' icon-user-follow';
		$this->data['nov_vraboten_header'] = $this->lang->line('sidebar_menu_vnesuvanje_na_vraboten');
		$this->data['nov_vraboten_header_icon'] = ' icon-user-follow';

		$this->data['main_view'] = 'admin/nov_vraboten';
		$this->template->load($this->data);
	}
	
	/**
	 * Nov vraboten (administrator od operator so hrana)
	 *
	 */
	public function nov_vraboten_operator_hrana()
	{
		if ($this->input->post('insert') && $this->input->post('novo_ime') && $this->input->post('novo_prezime')){
			$novo_ime = $this->input->post('novo_ime');
			$novo_prezime = $this->input->post('novo_prezime');
			$kod_karticka = $this->input->post('kod_karticka');
			$uloga = $this->input->post('uloga');
			
			if($this->home_model->nov_vraboten_operator_hrana($novo_ime, $novo_prezime, $kod_karticka, $uloga))
			{
				$this->data['msg_pass_success'] = TRUE;
			}
			else
			{
				$this->data['msg_pass_error'] = TRUE;
			}
		}
		$this->data['sidebar_navigation'] = 'nov_vraboten';
		$this->data['breadcrumb_text'] = $this->lang->line('sidebar_menu_vnesuvanje_na_vraboten');
		$this->data['breadcrumb_icon'] = ' icon-user-follow';
		$this->data['nov_vraboten_header'] = $this->lang->line('sidebar_menu_vnesuvanje_na_vraboten');
		$this->data['nov_vraboten_header_icon'] = ' icon-user-follow';

		$this->data['main_view'] = 'admin/nov_vraboten2';
		$this->template->load($this->data);
	}
	
	/**
	 * Otsustvo na vraboten
	 *
	 */
	public function otsustvo()
	{
		$this->data['all_employees'] = $this->home_model->get_all_employees();
	//	$this->data['start_date'] = date('Y-m-d H:i:s');
    //    $this->data['end_date'] = date('Y-m-d H:i:s');
		$date = date('Y/m/d');
		
		$start_date = strtotime($date);
		$end_date = strtotime($date);
		
		$from_date = date("Y-m-d", strtotime($date));
		$to_date = date("Y-m-d", strtotime($date));

		// Remove leading '--' from date strings
		$this->data['from_date'] = ltrim($from_date, '-');
		$this->data['to_date'] = ltrim($to_date, '-');
		
		if ($this->input->post('insert') && $this->input->post('vraboten_id') && $this->input->post('start_date') && $this->input->post('end_date') && $this->input->post('tip_otsustvo')){
			$vraboten = $this->input->post('vraboten_id');
			$start_date = convert_date_db($this->input->post('start_date'));
			$end_date = convert_date_db($this->input->post('end_date'));
			$tip_otsustvo = $this->input->post('tip_otsustvo');
			
			if($this->home_model->otsustvo($vraboten, $start_date, $end_date, $tip_otsustvo))
			{
				$this->data['msg_pass_success'] = TRUE;
			}
			else
			{
				$this->data['msg_pass_error'] = TRUE;
			}
		}

		$this->data['sidebar_navigation'] = 'otsustvo';
		$this->data['breadcrumb_text'] = $this->lang->line('sidebar_menu_otsustvo_vraboten');
		$this->data['breadcrumb_icon'] = 'icon-close';
		$this->data['otsustvo_header'] = $this->lang->line('sidebar_menu_otsustvo');
		$this->data['otsustvo_header_icon'] = 'icon-close';

		$this->data['main_view'] = 'admin/otsustvo';
		$this->template->load($this->data);
	}
	
	/**
	 * Otsustvo na vraboten (administrator od operator so hrana)
	 *
	 */
	public function otsustvo_operator_hrana()
	{
		$this->data['all_employees'] = $this->home_model->get_all_employees();
	//	$this->data['start_date'] = date('Y-m-d H:i:s');
    //    $this->data['end_date'] = date('Y-m-d H:i:s');
		$date = date('Y/m/d');
		
		$start_date = strtotime($date);
	//	$start_date = strtotime("next monday +1 week", $start_date);
		$this->data['start_date'] = date('Y-m-d H:i:s',$start_date);
		
		$end_date = strtotime($date);
	//	$end_date = strtotime("next friday +1 week", $end_date);
		//$end_date = strtotime("+7 day", $end_date);
		$this->data['end_date'] = date('Y-m-d H:i:s',$end_date);
		
		if ($this->input->post('insert') && $this->input->post('vraboten_id') && $this->input->post('start_date') && $this->input->post('end_date') && $this->input->post('tip_otsustvo')){
			$vraboten = $this->input->post('vraboten_id');
			$start_date = convert_date_db($this->input->post('start_date'));
			$end_date = convert_date_db($this->input->post('end_date'));
			$tip_otsustvo = $this->input->post('tip_otsustvo');
			
			if($this->home_model->otsustvo($vraboten, $start_date, $end_date, $tip_otsustvo))
			{
				$this->data['msg_pass_success'] = TRUE;
			}
			else
			{
				$this->data['msg_pass_error'] = TRUE;
			}
		}

		$this->data['sidebar_navigation'] = 'otsustvo';
		$this->data['breadcrumb_text'] = $this->lang->line('sidebar_menu_otsustvo_vraboten');
		$this->data['breadcrumb_icon'] = 'icon-close';
		$this->data['otsustvo_header'] = $this->lang->line('sidebar_menu_otsustvo');
		$this->data['otsustvo_header_icon'] = 'icon-close';

		$this->data['main_view'] = 'admin/otsustvo2';
		$this->template->load($this->data);
	}
	
	/**
	 * Vnesuvanje menija
	 *
	 */
	public function vnesi_meni()
	{		
		$next_week = strtotime('next week');
		$date_monday = date("d.m.Y", strtotime('monday', $next_week));
		$date_sunday = date("d.m.Y", strtotime('sunday', $next_week));
	
		$from_date = convert_date_db($date_monday);
		$to_date = convert_date_db($date_sunday);
		
		$this->data['from_date'] = $from_date;
		$this->data['to_date'] = $to_date;

		$date = date('Y/m/d');
		
		$start_date = strtotime($date);
	//	$start_date = strtotime("next monday +1 week", $start_date);
		$this->data['start_date'] = date('Y-m-d H:i:s',$start_date);
		
		$end_date = strtotime($date);
	//	$end_date = strtotime("next friday +1 week", $end_date);
		//$end_date = strtotime("+7 day", $end_date);
		$this->data['end_date'] = date('Y-m-d H:i:s',$end_date);

		$this->data['sidebar_navigation'] = 'vnesi_meni';
		$this->data['breadcrumb_text'] = $this->lang->line('sidebar_menu_vnesi_meni');
		$this->data['breadcrumb_icon'] = 'icon-book-open';
		$this->data['otsustvo_header'] = $this->lang->line('sidebar_menu_vnesi_meni');
		$this->data['otsustvo_header_icon'] = 'icon-book-open';

		$this->data['main_view'] = 'admin/vnesi_meni';
		$this->template->load($this->data);
	}
	
	public function zacuvaj_meni()
	{
	//	$start_date = convert_date_db($this->input->post('start_date'));
		$start_date = $this->input->post('start_date');
	//	$end_date = convert_date_db($this->input->post('end_date'));
		$end_date = $this->input->post('end_date');
		$meni_za_den = $this->input->post('meni_za_den');
		$izbor_meni = $this->input->post('izbor_meni');
		$jadenje = $this->input->post('jadenje');
			
		$result = $this->home_model->postoi_meni_za_period($start_date,$end_date,$meni_za_den,$izbor_meni);
			
		if (!empty($result)) {
			$this->home_model->delete_meni($start_date,$end_date,$meni_za_den,$izbor_meni);
		}
			
		$result2 = $this->home_model->vnesi_meni($start_date, $end_date, $meni_za_den, $izbor_meni, $jadenje);
		
		echo(json_encode($result2));
		
	}
	
	/**
	 * Pregled na menija
	 *
	 */
	public function pregled_meni()
	{
		$date = date('Y-m-d');
		
		$start_date = date("d.m.Y", strtotime($date));
		$this->data['start_date'] = date("Y-m-d", strtotime($date));
		
		$end_date = date("d.m.Y", strtotime( "$date +1 month" ));
		$this->data['end_date'] = date("Y-m-d", strtotime( "$date +1 month" ));
		
		$from_date = convert_date_db($start_date);
		$to_date = convert_date_db($end_date);

		$this->data['pregled_meni'] = $this->home_model->pregled_meni($from_date, $to_date);
					
		$this->data['sidebar_navigation'] = 'menija';
		$this->data['breadcrumb_text'] = $this->lang->line('sidebar_menu_pregled_na_meni');
		$this->data['breadcrumb_icon'] = 'icon-book-open';
		$this->data['otsustvo_header'] = $this->lang->line('sidebar_menu_pregled_na_meni');
		$this->data['otsustvo_header_icon'] = 'icon-book-open';

		$this->data['main_view'] = 'admin/pregled_meni';
		$this->template->load($this->data);
	}
	
	/**
	 * Select za izvestaj na vraboteni
	 *
	 */
	public function izvestaj_vraboteni()
	{
		$date = date('Y/m/d');
		
		$start_date = strtotime($date);
		$this->data['start_date'] = date('Y-m-d H:i:s',$start_date);

		$this->data['izvestaj'] = $this->home_model->izvestaj_vraboteni();
					
		$this->data['main_view'] = 'admin/get_izvestaj_vraboteni';
        $this->template->load($this->data);
	}
	
	public function excel() 
	{ 
		//load our new PHPExcel library 
		$this->load->library('excel'); 
		//activate worksheet number 1 
		$this->excel->setActiveSheetIndex(0); 
		//name the worksheet 
		$this->excel->getActiveSheet()->setTitle('Vraboteni'); 
		// load database 
		$this->load->database(); 
		// load model 
		$this->load->model('home_model');
		//get headers 
		$headers = array("Ime","Prezime", "Broj na karticka", "Datum na prijavuvanje", "Vreme na prijavuvanje");
		$this->excel->getActiveSheet()->fromArray($headers, null, 'A1');
		$this->excel->getActiveSheet()->getStyle('A1:E1')->getFont()->setSize(12);
		$this->excel->getActiveSheet()->getStyle('A1:E1')->getFont()->setBold(true);
		// get all users in array formate 
		$date = date('Y/m/d');		
		$start_date_str = strtotime($date);
		$startDate = date('Y-m-d',$start_date_str);
		
		$users = $this->home_model->izvestaj_vraboteni($startDate);
		// read data to active sheet 
		$this->excel->getActiveSheet()->fromArray($users, null, 'A2');
		$filename='prijaveni_vraboteni_na_den.xls'; 
		//save our workbook as this file name 
		header('Content-Type: application/vnd.ms-excel'); 
		//mime type 
		header('Content-Disposition: attachment;filename="'.$filename.'"'); 
		//tell browser what's the file name 
		header('Cache-Control: max-age=0'); 
		//no cache 
		//save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type) 
		//if you want to save it as.XLSX Excel 2007 format 
		$objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5'); 
		//force user to download the Excel file without writing it to server's HD 
		$objWriter->save('php://output');
	} 
	
	public function excel_lista_naracki() 
	{ 
		$start_date = $this->input->get('start_date');
		$end_date = $this->input->get('end_date');
		//load our new PHPExcel library 
		$this->load->library('excel'); 
		//activate worksheet number 1 
		$this->excel->setActiveSheetIndex(0); 
		//name the worksheet 
		$this->excel->getActiveSheet()->setTitle('Lista na naracki'); 
		// load database 
		$this->load->database(); 
		// load model 
		$this->load->model('home_model');
		//get headers 
		$headers = array("Ime", "Prezime", "Br. na karticka", "Lokacija", "Ponedelnik", "Vtornik", "Sreda", "Cetvrtok", "Petok", "Sabota", "Nedela");
		$this->excel->getActiveSheet()->fromArray($headers, null, 'A1');
		$this->excel->getActiveSheet()->getStyle('A1:L1')->getFont()->setSize(12);
		$this->excel->getActiveSheet()->getStyle('A1:L1')->getFont()->setBold(true);
		// get all users in array formate 
		$next_week = strtotime('next week');
		$date_monday = date("d.m.Y", strtotime('monday', $next_week));
		$date_sunday = date("d.m.Y", strtotime('sunday', $next_week));
		
		$from_date = convert_date_db($date_monday);
		$to_date = convert_date_db($date_sunday);
		
		$lista_naracki = $this->home_model->lista_naracki($start_date ? $start_date . " 00:00:00" : $from_date, $end_date ? $end_date . " 00:00:00" : $to_date);
		// read data to active sheet 
		$this->excel->getActiveSheet()->fromArray($lista_naracki, null, 'A2');
		$filename='lista_na_naracki' . $start_date . '--' . $end_date . '.xls'; 
		//save our workbook as this file name 
		header('Content-Type: application/vnd.ms-excel'); 
		//mime type 
		header('Content-Disposition: attachment;filename="'.$filename.'"'); 
		//tell browser what's the file name 
		header('Cache-Control: max-age=0'); 
		//no cache 
		//save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type) 
		//if you want to save it as.XLSX Excel 2007 format 
		$objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5'); 
		//force user to download the Excel file without writing it to server's HD 
		$objWriter->save('php://output');
	} 
	
	public function live_lista_naracki()
	{
		$this->data['current_date'] = date('d/m/Y');
		$this->data['data'] = $this->get_user_data();
		$this->data['main_view'] = 'admin/live_lista_naracki';
		$this->data['sidebar_navigation'] = 'live_lista_naracki';
        $this->template->load($this->data);
	}
	
	public function excel_lista_otsustvo() 
	{ 
      //load our new PHPExcel library 
      $this->load->library('excel'); 
      //activate worksheet number 1 
      $this->excel->setActiveSheetIndex(0); 
      //name the worksheet 
      $this->excel->getActiveSheet()->setTitle('Lista na otsustva'); 
      // load database 
      $this->load->database(); 
      // load model 
      $this->load->model('home_model');
	  //get headers 
	  $headers = array("Prezime", "Ime", "Od", "Do", "Tip na otsustvo");
	  $this->excel->getActiveSheet()->fromArray($headers, null, 'A1');
	  $this->excel->getActiveSheet()->getStyle('A1:E1')->getFont()->setSize(12);
	  $this->excel->getActiveSheet()->getStyle('A1:E1')->getFont()->setBold(true);
      // get all users in array formate 
	  $date = date('Y/m/d');		
      $start_date = strtotime($date);
	  $startDate = date('Y-m-d',$start_date);
      $users = $this->home_model->izvestaj_otsustvo($startDate);
      // read data to active sheet 
	  $this->excel->getActiveSheet()->fromArray($users, null, 'A2'); 
      $filename='vraboteni_so_otsustvo.xls'; 
      //save our workbook as this file name 
      header('Content-Type: application/vnd.ms-excel'); 
      //mime type 
      header('Content-Disposition: attachment;filename="'.$filename.'"'); 
      //tell browser what's the file name 
      header('Cache-Control: max-age=0'); 
      //no cache 
      //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type) 
      //if you want to save it as.XLSX Excel 2007 format 
      $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5'); 
      //force user to download the Excel file without writing it to server's HD 
      $objWriter->save('php://output');
	} 
	
	private function get_user_data()
	{
		$datesMkDays = [
			'monday' => 'ponedelnik',
			'tuesday' => 'vtornik',
			'wednesday' => 'sreda',
			'thursday' => 'cetvrtok',
			'friday' => 'petok',
			'saturday' => 'sabota',
			'sunday' => 'nedela',
		];
		$currentDateDay = date("l");
		$mkDateDay = $datesMkDays[strtolower($currentDateDay)];
		
		$users = $this->home_model->izvestaj_vraboteni_za_lista();
		
		$tekovno_from_date = date("Y-m-d", strtotime('monday this week'));
		$tekovno_to_date = date("Y-m-d", strtotime('sunday this week'));
		
		$data = [];
		foreach ($users as $user) {
			$smenaQ = $this->home_model->odbrana_smena($user['id'],$tekovno_from_date,$tekovno_to_date);
			$odbranaSmenaArray = $smenaQ->result();
			$odbranaSmena = (int) $odbranaSmenaArray[0]->smena;
			$odbranoMeniData = $this->home_model->odbrano_meni_za_lista_user($user);
			
			if (!empty($odbranoMeniData)) {
				if ($odbranaSmena == 3 && strtolower($currentDateDay) != 'monday') {
					$previousDay = strtolower(date('l', strtotime("-1 days")));
					$prevMkDateDay = $datesMkDays[strtolower($previousDay)];

					if ($prevMkDateDay) {
						$responseRow = [
							'ime' => $user['ime'],
							'prezime' => $user['prezime'],
							'kod_karticka' => $user['kod_karticka'],
							'day_value' => $odbranoMeniData[0][$prevMkDateDay],
							'odbrana_smena' => $odbranaSmena,
							'meni_data' => $odbranoMeniData
						];

						$data[] = $responseRow;
					}
					continue;
				}
				
				$responseRow = [
					'ime' => $user['ime'],
					'prezime' => $user['prezime'],
					'kod_karticka' => $user['kod_karticka'],
					'day_value' => $odbranoMeniData[0][$mkDateDay],
					'odbrana_smena' => $odbranaSmena,
					'meni_data' => $odbranoMeniData
				];

				$data[] = $responseRow;
			}
		}
		return $data;
	}
	
	public function live_lista_naracki_data()
	{
		$data = $this->get_user_data();
		header('Content-Type: application/json');
		echo json_encode($data);
	}
	
	public function profile()
	{
		$this->data['current_date'] = date('d/m/Y');
		$this->data['data'] =  $this->data['client_data']->row();
		$this->data['main_view'] = 'admin/profile';
        $this->template->load($this->data);
	}

	public function edit_profile()
	{
		$this->data['current_date'] = date('d/m/Y');
		$this->data['data'] = $this->data['client_data']->row();
		$this->data['main_view'] = 'admin/edit_profile';
		$this->template->load($this->data);
	}

	public function update_profile()
	{
		$data = array(
			'ime' => $this->input->post('ime'),
			'prezime' => $this->input->post('prezime'),
			'kod_karticka' => $this->input->post('kod_karticka'),
			'id' => $this->input->post('id')
		);

		$this->home_model->update_profile($data);

		redirect('admin/profile');
	}
	
	public function edit_employee($employee_id)
	{
		$this->load->model('employee_model');
		$employee_data = $this->employee_model->get_employee_by_id($employee_id);
		
		$this->data['employee'] = $employee_data;
		$this->data['main_view'] = 'admin/edit_employee';
		$this->template->load($this->data);
	}

	public function update_employee()
	{
		$this->load->model('employee_model');
		
		$employee_id = $this->input->post('id');
		
		$employee_data = [
			'ime' => $this->input->post('ime'),
			'prezime' => $this->input->post('prezime'),
			'kod_karticka' => $this->input->post('kod_karticka')
		];

		$this->employee_model->update_employee($employee_id, $employee_data);
		
		redirect('admin/index');
	}
}

/* End of file admin.php */
/* Location: ./application/controllers/admin.php */