<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/*
 * Home Model
 */

class Home_model extends CI_Model
{
	public function __construct ()
	{
		parent::__construct ();
	}

	public function insert_new_client ($ins_arr)
	{
		$client = $this->get_client_for_insert($ins_arr['ac_subject']);

		if($client->num_rows()){

			$ins_data['ac_subject'] = $ins_arr['ac_subject'];
			$ins_data['ac_web_user_id'] = $ins_arr['ac_web_user_id'];

			if ($ins_arr['ac_name2'])
				$ins_data['ac_name2'] = $ins_arr['ac_name2'];
			
			if ($ins_arr['ac_name3'])
				$ins_data['ac_name3'] = $ins_arr['ac_name3'];
			
			if ($ins_arr['ac_phone'])
				$ins_data['ac_phone'] = $ins_arr['ac_phone'];
			
			if ($ins_arr['ac_email'])
				$ins_data['ac_email'] = $ins_arr['ac_email'];

			if (!$client->row()->password_status)
				$ins_data['ac_password'] = $ins_arr['ac_password'];
			
    	    $this->db->where('ac_subject', $ins_data['ac_subject']);
	        $this->db->update("clients", $ins_data);
			return FALSE;
		} else {
			$ins_arr['language'] = DEFAULT_LANGUAGE;
			$ins_arr['created_on'] = date('Y-m-d H:i:s');
			$this->db->insert("clients", $ins_arr);
			return TRUE;
		}
	}

	public function get_client_for_insert ($ac_subject)
	{
        $this->db->select("*");
        $this->db->where("ac_subject", $ac_subject);
        return $this->db->get("clients");
	}
	
	
	
	
	

	//proverka dali postoi korisnikot
	public function check_login($username, $password)
	{
        $this->db->select("*");
		$this->db->where("aktiven", 1);
        $this->db->where("username", $username);
		$this->db->where("password", $password);
        $result = $this->db->get("korisnici");
		
		if($result->num_rows())
			return $result->row()->username;
		return FALSE;
	}
	
	//proverka dali postoi korisnikot preku rfid karticka
	public function check_login_rfid($rfid)
	{
        $this->db->select("*");
		$this->db->where("aktiven", 1);
        $this->db->where("kod_karticka", $rfid);
        $result = $this->db->get("korisnici");
		if($result->num_rows())
			return $result->row()->username;
		return FALSE;
	}
	
	//zema podatoci za korisnikot
	public function get_client ($username)
	{
        $this->db->select("*");
		$this->db->where("aktiven", 1);
        $this->db->where("username", $username);
        return $this->db->get("korisnici");
	}
	
	//zema podatoci za korisnik od tabelata korisnici i od tabelata smena
	public function get_all_data_client ($ime, $limit = 1)
	{
        $this->db->select("*");
		$this->db->where("aktiven", 1);
        $this->db->where("ime", $ime);
		$this->db->join("smena", "smena.korisnik_id = korisnici.id", "left");
		$this->db->order_by("od_datum", 'desc');
		$this->db->limit($limit);
        return $this->db->get("korisnici");
	}
	
	//gi zema site korisnici
	public function get_all_employees ()
	{
        $this->db->select("*");
		$this->db->order_by("id","desc");
        return $this->db->get("korisnici");
	}
	
	//zema id za korisnik spored ime i prezime
	public function get_korisnik ($ime, $prezime)
	{
        $this->db->select("id");
		$this->db->from("korisnici");
        $this->db->where("ime", $ime);
		if (strlen($prezime) > 0) {
			$this->db->where("prezime", $prezime);
		}
        $query = $this->db->get();
		
        return $query->result();
	}
	
	//insert na smena vo baza
	 public function insert_smena($smena, $from_date, $to_date, $korisnik_id)
	 {
		 $dataInsert = array(
                "korisnik_id"    => $korisnik_id,
                "od_datum"       => $from_date,
                "do_datum"       => $to_date,
                "smena"    		 => $smena
            );
		 
        $this->db->insert('smena', $dataInsert);
	 }
	 
	 //zema smena za odreden period
	public function odbrana_smena ($korisnik_id, $from_date, $to_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $from_date);
		$this->db->where("do_datum <=", $to_date);
		$this->db->where("korisnik_id", $korisnik_id);
        return $this->db->get("smena");
	}
	
	//zema meni za odreden period
	public function odbrano_meni ($korisnik_id, $from_date, $to_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $from_date);
		$this->db->where("do_datum <=", $to_date);
		$this->db->where("korisnik_id", $korisnik_id);
        return $this->db->get("odbereno_meni");
	}
	
	//proveruva dali ima smena za daden period
	public function proveri_smena_za_period ($korisnik_id, $from_date, $to_date)
	{
        $this->db->select("*");
		$this->db->from("smena");
		$this->db->where("od_datum >=", $from_date);
		$this->db->where("do_datum <=", $to_date);
		$this->db->where("korisnik_id", $korisnik_id);
        $query = $this->db->get();

        return $query->result();
	}
	
	//proveruva dali ima meni za daden period
	public function proveri_meni_za_period ($korisnik_id, $from_date, $to_date)
	{
        $this->db->select("*");
		$this->db->from("odbereno_meni");
		$this->db->where("od_datum >=", $from_date);
		$this->db->where("do_datum <=", $to_date);
		$this->db->where("korisnik_id", $korisnik_id);
        $query = $this->db->get();

        return $query->result();
	}
	
	//brise smena za daden period
	public function izbrisi_smena_za_period($k_id, $od_datum, $do_datum)
	{
		$this->db->where("od_datum >=", $od_datum);
		$this->db->where("do_datum <=", $do_datum);
		$this->db->where("korisnik_id", $k_id);
		$this->db->delete("smena");
	}
	
	//brise meni za daden period
	public function izbrisi_meni_za_period($k_id, $od_datum, $do_datum)
	{
		$this->db->where("od_datum >=", $od_datum);
		$this->db->where("do_datum <=", $do_datum);
		$this->db->where("korisnik_id", $k_id);
		$this->db->delete("odbereno_meni");
	}
	
	 //brisenje na vraboten
	 public function delete_employee($ime, $prezime)
	 {
		$this->db->where('ime', $ime);
		 if (strlen($prezime) > 0) {
			$this->db->where("prezime", $prezime);
		}
		$this->db->delete('korisnici');
	 }
	 
	 //insert na korisnik vo baza
	 public function nov_vraboten($novo_ime, $novo_prezime, $kod_karticka, $uloga, $korisnicko_ime, $lozinka)
	 {
		 $dataKorisnik = array(
                "ime"    		=> $novo_ime,
                "prezime"       => $novo_prezime,
                "kod_karticka"  => $kod_karticka,
                "uloga"    		=> $uloga,
				"username"    	=> $korisnicko_ime,
				"password"      => $lozinka
            );
			
		$this->db->insert('korisnici', $dataKorisnik);
		
		if ($this->db->affected_rows())
			return TRUE;
		else
			return FALSE;
	 }
	
		 	 //insert na korisnik vo baza
	 public function nov_vraboten_operator_hrana($novo_ime, $novo_prezime, $kod_karticka, $uloga)
	 {
		 $username = $novo_ime.".".$novo_prezime;
		 $dataKorisnik = array(
                "ime"    		=> $novo_ime,
                "prezime"       => $novo_prezime,
                "kod_karticka"  => $kod_karticka,
                "uloga"    		=> $uloga,
				"username"    	=> $username,
				"password"      => $kod_karticka
            );
			
		$this->db->insert('korisnici', $dataKorisnik);
		
		if ($this->db->affected_rows())
			return TRUE;
		else
			return FALSE;
	 }
	 
	 //insert na otsustvo na vraboten vo baza
	 public function otsustvo($vraboten, $start_date, $end_date, $tip_otsustvo)
	 {
		 $dataOtsustvo = array(
                "korisnik_id"    	=> $vraboten,
                "datum_denovi_od"   => $start_date,
                "datum_denovi_do"   => $end_date,
                "tip_na_otsustvo"   => $tip_otsustvo
            );
			
		$this->db->insert('otsustvo', $dataOtsustvo);
		
		if ($this->db->affected_rows())
			return TRUE;
		else
			return FALSE;
	 }
	 
	 //proveruva dali ima vneseno meni za daden period
	public function postoi_meni_za_period($start_date,$end_date,$meni_za_den,$izbor_meni)
	{
        $this->db->select("*");
		$this->db->from("meni");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("den", $meni_za_den);
		$this->db->where("meni", $izbor_meni);
        $query = $this->db->get();

        return $query->result();
	}
	
	// brisenje na vnesenoto meni za daden period
	public function delete_meni($start_date,$end_date,$meni_za_den,$izbor_meni)
	{
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("den", $meni_za_den);
		$this->db->where("meni", $izbor_meni);
		$this->db->delete("meni");
	}
	
	 //insert na meni vo baza
	 public function vnesi_meni($start_date, $end_date, $meni_za_den, $izbor_meni, $jadenje)
	 {
		 $dataMeni = array(
                "od_datum"   => $start_date,
                "do_datum"   => $end_date,
                "den"   	 => $meni_za_den,
				"meni"       => $izbor_meni,
				"jadenje"    => $jadenje
            );
			
		$this->db->insert('meni', $dataMeni);
		
	//	if ($this->db->affected_rows())
	//		return TRUE;
	//	else
	//		return FALSE;
	 }
	 
	 //insert na odbereno meni vo baza
	 public function insert_odbrano_meni($ponedelnik, $vtornik, $sreda, $cetvrtok, $petok, $sabota, $from_date, $to_date, $korisnik_id)
	 {
		 $dataOdberenoMeni = array(
                "korisnik_id"    => $korisnik_id,
                "od_datum"       => $from_date,
                "do_datum"       => $to_date,
                "ponedelnik"     => $ponedelnik,
				"vtornik"        => $vtornik,
				"sreda"     	 => $sreda,
				"cetvrtok"    	 => $cetvrtok,
				"petok"   		 => $petok,
				"sabota"     	 => $sabota
            );

        $this->db->insert('odbereno_meni', $dataOdberenoMeni);
	 }
	
	//zema meni za podolg period
	public function pregled_meni($start_date, $end_date)
	{
        $this->db->select("*");
	//	$this->db->from("meni");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
        return $this->db->get("meni");
	//	$query = $this->db->get();

        return $query->result();
	}
	 
	 //zema meni za period
	public function get_meni($start_date, $end_date)
	{
        $this->db->select("*");
		//$this->db->from("meni");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
        return $this->db->get("meni");
		//$query = $this->db->get();

        //return $query->result();
	}
	
	//zema meni1 za ponedelnik
	public function get_meni1_ponedelnik($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "normal_m1");
		$this->db->where("den", "ponedelnik");
        return $this->db->get("meni");
	}
	
	//zema meni2 za ponedelnik
	public function get_meni2_ponedelnik($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "m2_salata");
		$this->db->where("den", "ponedelnik");
        return $this->db->get("meni");;
	}
	
	//zema posno za ponedelnik
	public function get_posno_ponedelnik($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "suvo_m3");
		$this->db->where("den", "ponedelnik");
        return $this->db->get("meni");;
	}
	
	//zema posno za ponedelnik
	public function get_posno2_ponedelnik($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "posno");
		$this->db->where("den", "ponedelnik");
        return $this->db->get("meni");;
	}
	
	//zema posno za vtornik
	public function get_posno2_vtornik($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "posno");
		$this->db->where("den", "vtornik");
        return $this->db->get("meni");;
	}
	//zema posno za sreda
	public function get_posno2_sreda($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "posno");
		$this->db->where("den", "sreda");
        return $this->db->get("meni");;
	}
	//zema posno za cetvrtok
	public function get_posno2_cetvrtok($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "posno");
		$this->db->where("den", "cetvrtok");
        return $this->db->get("meni");;
	}
	//zema posno za petok
	public function get_posno2_petok($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "posno");
		$this->db->where("den", "petok");
        return $this->db->get("meni");;
	}
	//zema posno za sabota
	public function get_posno2_sabota($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "posno");
		$this->db->where("den", "sabota");
        return $this->db->get("meni");;
	}
	
	//zema vege za ponedelnik
	public function get_vege_ponedelnik($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "vege");
		$this->db->where("den", "ponedelnik");
        return $this->db->get("meni");;
	}
	
	//zema meni1 za vtornik
	public function get_meni1_vtornik($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "normal_m1");
		$this->db->where("den", "vtornik");
        return $this->db->get("meni");
	}
	
	//zema meni2 za vtornik
	public function get_meni2_vtornik($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "m2_salata");
		$this->db->where("den", "vtornik");
        return $this->db->get("meni");
	}
	
	//zema posno za vtornik
	public function get_posno_vtornik($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "suvo_m3");
		$this->db->where("den", "vtornik");
        return $this->db->get("meni");
	}
	
	//zema vege za vtornik
	public function get_vege_vtornik($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "vege");
		$this->db->where("den", "vtornik");
        return $this->db->get("meni");
	}
	
	//zema meni1 za sreda
	public function get_meni1_sreda($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "normal_m1");
		$this->db->where("den", "sreda");
        return $this->db->get("meni");
	}
	
	//zema meni2 za sreda
	public function get_meni2_sreda($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "m2_salata");
		$this->db->where("den", "sreda");
        return $this->db->get("meni");
	}
	
	//zema posno za sreda
	public function get_posno_sreda($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "suvo_m3");
		$this->db->where("den", "sreda");
        return $this->db->get("meni");
	}
	
	//zema vege za sreda
	public function get_vege_sreda($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "vege");
		$this->db->where("den", "sreda");
        return $this->db->get("meni");
	}
	
	//zema meni1 za cetvrtok
	public function get_meni1_cetvrtok($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "normal_m1");
		$this->db->where("den", "cetvrtok");
        return $this->db->get("meni");
	}
	
	//zema meni2 za cetvrtok
	public function get_meni2_cetvrtok($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "m2_salata");
		$this->db->where("den", "cetvrtok");
        return $this->db->get("meni");
	}
	
	//zema posno za cetvrtok
	public function get_posno_cetvrtok($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "suvo_m3");
		$this->db->where("den", "cetvrtok");
        return $this->db->get("meni");
	}
	
	//zema vege za cetvrtok
	public function get_vege_cetvrtok($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "vege");
		$this->db->where("den", "cetvrtok");
        return $this->db->get("meni");
	}
	
	//zema meni1 za petok
	public function get_meni1_petok($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "normal_m1");
		$this->db->where("den", "petok");
        return $this->db->get("meni");
	}
	
	//zema meni2 za petok
	public function get_meni2_petok($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "m2_salata");
		$this->db->where("den", "petok");
        return $this->db->get("meni");
	}
	
	//zema posno za petok
	public function get_posno_petok($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "suvo_m3");
		$this->db->where("den", "petok");
        return $this->db->get("meni");
	}
	
	//zema vege za petok
	public function get_vege_petok($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "vege");
		$this->db->where("den", "petok");
        return $this->db->get("meni");
	}
	
	//zema meni1 za sabota
	public function get_meni1_sabota($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "normal_m1");
		$this->db->where("den", "sabota");
        return $this->db->get("meni");
	}
	
	//zema meni2 za sabota
	public function get_meni2_sabota($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "m2_salata");
		$this->db->where("den", "sabota");
        return $this->db->get("meni");
	}
	
	//zema posno za sabota
	public function get_posno_sabota($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "suvo_m3");
		$this->db->where("den", "sabota");
        return $this->db->get("meni");
	}
	
	//zema vege za sabota
	public function get_vege_sabota($start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("od_datum >=", $start_date);
		$this->db->where("do_datum <=", $end_date);
		$this->db->where("meni", "vege");
		$this->db->where("den", "sabota");
        return $this->db->get("meni");
	}
	
	//prijavuvanje smena
	 public function prijavuvanje_smena($korisnik_id, $datum, $time)
	 {
		 $dataTime = array(
                "korisnik_id"   => $korisnik_id,
				"datum" => $datum,
                "smena_begin"   => $time
            );
			
		$this->db->insert('prijavuvanje_smena', $dataTime);
		
		if ($this->db->affected_rows())
			return TRUE;
		else
			return FALSE;
	 }
	 
	 //izvestaj vraboteni
	 public function izvestaj_vraboteni($startDate)
	 {
		$this->db->select("ime, prezime, kod_karticka, datum, smena_begin");
		$this->db->join("korisnici", "korisnici.id = prijavuvanje_smena.korisnik_id", "left");
		$this->db->where("datum", $startDate); 
		 $this->db->group_by("korisnici.id");
     //   return $this->db->get("prijavuvanje_smena");
		$query = $this->db->get("prijavuvanje_smena");
		return $query->result_array();
	 }
	
	//izvestaj na otsustva
	 public function izvestaj_otsustvo($startDate)
	 {
		$this->db->select("prezime, ime, datum_denovi_od, datum_denovi_do, tip_na_otsustvo");
		$this->db->join("korisnici", "korisnici.id = otsustvo.korisnik_id", "left");
		$this->db->where("datum_denovi_do >=", $startDate); 
		$query = $this->db->get("otsustvo");
		return $query->result_array();
	 }
	
	public function izvestaj_vraboteni_za_lista()
	 {
		$this->db->select("*");
		$query = $this->db->get("korisnici");
		
		return $query->result_array();
	 }
	 
	public function odbrano_meni_za_lista_user($user)
	{
		$currentDate = new DateTime($user['datum']);
		$startOfWeek = clone $currentDate;
		$startOfWeek->modify('this week');
		$startOfWeek->modify('Monday');
		$endOfWeek = clone $startOfWeek;
		$endOfWeek->modify('Sunday');
		
		$startOfWeekStr = $startOfWeek->format('Y-m-d H:i:s');
		$endOfWeekStr = $endOfWeek->format('Y-m-d H:i:s');
		
		$this->db->select("*");
		$this->db->where("korisnik_id", $user['id']);
		$this->db->where("do_datum >= '" . $startOfWeekStr . "'");
		$this->db->where("od_datum <= '" . $endOfWeekStr . "'");
		$odberenoQuery = $this->db->get("odbereno_meni");

		return $odberenoQuery->result_array();
	}
	 
	 //lista na naracki
	 public function lista_naracki($from_date,$to_date)
	 {
		$this->db->select("ime, prezime, kod_karticka, smena, ponedelnik, vtornik, sreda, cetvrtok, petok, sabota");
		$this->db->join("smena", "smena.korisnik_id = korisnici.id", "left");
		$this->db->join("odbereno_meni", "odbereno_meni.korisnik_id = korisnici.id", "left");
		$this->db->where("odbereno_meni.od_datum >= '" . $from_date . "'");
		$this->db->where("odbereno_meni.do_datum <= '" . $to_date . "'");
		$this->db->where("smena.od_datum >= '" . $from_date . "'");
		$this->db->where("smena.do_datum <= '" . $to_date . "'");
		$this->db->group_by("korisnici.id");
     //   return $this->db->get("prijavuvanje_smena");
		$query = $this->db->get("korisnici");
		return $query->result_array();
	 }

	public function get_all_clients_for_sync ()
	{
		$this->db->select("*");
		$this->db->where("clients_status", 1);
		$result = $this->db->get("clients");
		
		$out_arr = array();
		foreach ($result->result() as $single_result){
			$out_arr[$single_result->ac_subject] = $this->create_client_md5($single_result);
		}
		return $out_arr;
	}

	public function get_all_clients ()
	{
		$this->db->select("*");
		$this->db->where("clients_status", 1);
		return $this->db->get("clients");
	}

	public function create_client_md5($client)
	{
		$text = '';
		$text .= $client->ac_subject;
		if ($client->ac_name2)
			$text .= $client->ac_name2;
		if ($client->ac_name3)
			$text .= $client->ac_name3;
		if ($client->ac_phone)
			$text .= $client->ac_phone;
		if ($client->ac_email)
			$text .= $client->ac_email;
		$text .= $client->ac_web_user_id;
		$text .= $client->ac_password;
		
		return md5($text);
	}

	public function check_forgot_password_email($email)
	{
        $this->db->select("*");
		$this->db->where("clients_status", 1);
        $this->db->where("ac_email", $email);
        $result = $this->db->get("clients");
		
		if($result->num_rows())
			return $result;
		return FALSE;
	}

	public function insert_new_invoice ($ins_arr)
	{
		$client = $this->get_invoice_for_insert($ins_arr['ac_key']);

		if($client->num_rows()){
    	    $this->db->where('ac_key', $ins_arr['ac_key']);
	        $this->db->update("invoice", $ins_arr);
		} else {
			$ins_arr['created_on'] = date('Y-m-d H:i:s');
			$this->db->insert("invoice", $ins_arr);
		}
	}

	public function get_invoice_for_insert ($ac_key)
	{
        $this->db->select("*");
        $this->db->where("ac_key", $ac_key);
        return $this->db->get("invoice");
	}

	public function get_invoice ($ac_key)
	{
        $this->db->select("*");
		$this->db->where("invoice_status", 1);
        $this->db->where("ac_key", $ac_key);
        return $this->db->get("invoice");
	}

	public function get_all_client_invoices ($ac_subject)
	{
        $this->db->select("*");
		$this->db->where("invoice_status", 1);
        $this->db->where("ac_receiver", $ac_subject);
		$this->db->order_by("ad_date", 'desc');
        return $this->db->get("invoice");
	}

	public function get_last_client_invoices ($ac_subject, $limit = 10)
	{
        $this->db->select("*");
		$this->db->where("invoice_status", 1);
        $this->db->where("ac_receiver", $ac_subject);
		$this->db->order_by("ad_date", 'desc');
		$this->db->limit($limit);
        return $this->db->get("invoice");
	}

	public function get_all_client_invoices_date ($ac_subject, $start_date, $end_date)
	{
        $this->db->select("*");
		$this->db->where("invoice_status", 1);
        $this->db->where("ac_receiver", $ac_subject);
		$this->db->where('ad_date >=', $start_date);
		$this->db->where('ad_date <=', $end_date);
		$this->db->order_by("ad_date", 'desc');
        return $this->db->get("invoice");
	}

    public function get_date_span_client_invoices($ac_subject)
    {
        $query = "SELECT MIN(ad_date) as start_date, MAX(ad_date) as end_date 
                  FROM invoice WHERE invoice_status = 1 AND ac_receiver = ".$this->db->escape($ac_subject);
        return $this->db->query($query);
    }

	public function check_client_invoice ($ac_subject, $ac_key)
	{
        $this->db->select("*");
		$this->db->where("invoice_status", 1);
		$this->db->where("ac_key", $ac_key);
        $this->db->where("ac_receiver", $ac_subject);
        return $this->db->get("invoice");
	}

	public function check_open_invoices ($ac_subject)
	{
		$check_date = date('Y-m-d H:i:s');
		$check_created_on = date('Y-m-d H:i:s', strtotime($check_date) - TIME_FROM_INVOICE_UPLOAD);
        $this->db->select("*");
		$this->db->where("invoice_status", 1);
        $this->db->where("ac_receiver", $ac_subject);
		$this->db->where("invoice_send", 0);
		$this->db->where('ad_date <=', $check_date);
		$this->db->where('ad_date_valid >=', $check_date);
		$this->db->where('created_on <=', $check_created_on);
        return $this->db->get("invoice");
	}

	public function close_open_invoice ($ac_subject, $ac_key)
	{
		$ins_arr['invoice_send'] = 1;
		$ins_arr['invoice_send_date'] = date('Y-m-d H:i:s');
		$this->db->where('ac_key', $ac_key);
		$this->db->where("invoice_status", 1);
		$this->db->update("invoice", $ins_arr);
		
		$this->insert_new_mail_send($ac_subject, $ac_key, 1);
	}

	public function insert_new_mail_send ($ac_subject, $ac_key, $type, $note = 0)
	{
		$ins_arr['ac_subject_mail_send'] = $ac_subject;
		$ins_arr['ac_key_mail_send'] = $ac_key;
		$ins_arr['type'] = $type;
		if ($note)
			$ins_arr['note'] = $note;
		$ins_arr['mail_send_date'] = date('Y-m-d H:i:s');	
		$this->db->insert("mail_send ", $ins_arr);
	}

	public function get_all_client_mail_send ($ac_subject)
	{
        $this->db->select("*");
        $this->db->where("ac_subject_mail_send", $ac_subject);
        $this->db->where("status", 1);
		$this->db->order_by("mail_send_date", 'desc');
        return $this->db->get("mail_send");
	}

	public function get_last_client_mail_send ($ac_subject, $limit = 10)
	{
        $this->db->select("*");
        $this->db->where("ac_subject_mail_send", $ac_subject);
        $this->db->where("status", 1);
		$this->db->order_by("mail_send_date", 'desc');
		$this->db->limit($limit);
        return $this->db->get("mail_send");
	}

	public function get_number_client_mail_send ($ac_subject, $last_access)
	{
        $this->db->select("*");
        $this->db->where("ac_subject_mail_send", $ac_subject);
        $this->db->where("status", 1);
        $this->db->where("mail_send_date >=", $last_access);
        return $this->db->get("mail_send")->num_rows();
	}

	public function set_mail_send_warning ($ac_subject, $ac_key, $mail_send, $type = 2)
	{
		$ins_arr['mail_send'] = $mail_send + 1;
		$ins_arr['mail_send_last_date'] = date('Y-m-d H:i:s');
		$this->db->where('ac_key', $ac_key);
		$this->db->where("invoice_status", 1);
		$this->db->update("invoice", $ins_arr);
		
		$this->insert_new_mail_send($ac_subject, $ac_key, $type, $mail_send + 1);
	}

	public function check_all_warning_book_invoices ()
	{
		$check_date_valid = date('Y-m-d H:i:s', time() - TIME_FOR_FIRST_WARNING);
		$check_last_warning = date('Y-m-d H:i:s', time() - TIME_FOR_CONSECUTIVE_WARNING);
        $query = "SELECT *, sum(an_credit - an_debit) AS total_status 
				  FROM book 
				  LEFT JOIN clients ON clients.ac_subject = book.ac_subject 
				  LEFT JOIN invoice ON book.ac_lnk_key = invoice.ac_key 
				  WHERE clients.ac_email IS NOT NULL AND invoice.ac_key IS NOT NULL AND invoice.ad_date_valid <= '{$check_date_valid}' 
					  AND (
					  		(invoice.mail_send = 0 AND invoice.mail_send_last_date IS NULL)
								 OR 
							(invoice.mail_send <> 0 AND invoice.mail_send_last_date IS NOT NULL AND invoice.mail_send_last_date <= '{$check_last_warning}')
					  	  )
				  GROUP BY ac_lnk_key HAVING total_status < 0";
        return $this->db->query($query);
	}

	public function check_warning_mail_send ($ac_subject, $ac_key, $type)
	{
        $this->db->select("*");
        $this->db->where("ac_subject_mail_send", $ac_subject);
		$this->db->where("ac_key_mail_send", $ac_key);
		$this->db->where('type', $type);
        return $this->db->get("mail_send");
	}

	public function check_num_warning_mail_send ($ac_subject, $ac_key, $type)
	{
        $this->db->select("*");
        $this->db->where("ac_subject_mail_send", $ac_subject);
		$this->db->where("ac_key_mail_send", $ac_key);
		$this->db->where('type', $type);
        return $this->db->get("mail_send")->num_rows();
	}

	public function check_num_count_warning_mail_send ($ac_subject, $ac_key, $type)
	{
	    $this->db->where("ac_subject_mail_send", $ac_subject);
		$this->db->where("ac_key_mail_send", $ac_key);
		$this->db->where('type', $type);
		return $this->db->count_all_results('mail_send');
	}

	public function insert_new_book ($ins_arr)
	{
		$client = $this->get_book_for_insert($ins_arr['ac_key_book'], $ins_arr['an_no']);

		if($client->num_rows()){
    	    $this->db->where('ac_key_book', $ins_arr['ac_key_book']);
    	    $this->db->where('an_no', $ins_arr['an_no']);
	        $this->db->update("book", $ins_arr);
		} else {
			$ins_arr['created_on'] = date('Y-m-d H:i:s');
			$this->db->insert("book", $ins_arr);
		}
	}

	public function get_book_for_insert ($ac_key_book, $an_no)
	{
        $this->db->select("*");
        $this->db->where("ac_key_book", $ac_key_book);
        $this->db->where("an_no", $an_no);
        return $this->db->get("book");
	}

	public function get_book ($ac_key_book, $an_no)
	{
        $this->db->select("*");
		$this->db->where("book_status", 1);
        $this->db->where("ac_key_book", $ac_key_book);
        $this->db->where("an_no", $an_no);
        return $this->db->get("book");
	}

	public function client_change_password ($ac_subject, $new_pass)
	{
		$ins_arr['ac_password'] = $new_pass;
		$ins_arr['password_status'] = 1;
		$this->db->where("clients_status", 1);
   	    $this->db->where('ac_subject', $ac_subject);
        $this->db->update("clients", $ins_arr);

		if ($this->db->affected_rows())
			return TRUE;
		else
			return FALSE;
	}

	public function client_change_language ($ac_subject, $language)
	{
		$ins_arr['language'] = $language;
		$this->db->where("clients_status", 1);
   	    $this->db->where('ac_subject', $ac_subject);
        $this->db->update("clients", $ins_arr);

		if ($this->db->affected_rows())
			return TRUE;
		else
			return FALSE;
	}

	public function update_last_access ($ac_subject)
	{
		$client = $this->get_client($ac_subject);

		if($client->num_rows()){

			$ins_data['last_access_temp'] = date('Y-m-d H:i:s');
			if ($client->row()->last_access_temp)
				$ins_data['last_access'] = $client->row()->last_access_temp;
			else
				$ins_data['last_access'] = $ins_data['last_access_temp'];

			$this->db->where("clients_status", 1);
    	    $this->db->where('ac_subject', $ac_subject);
	        $this->db->update("clients", $ins_data);

			$ins_arr['ac_subject_log_access'] = $ac_subject;
			$ins_arr['last_access_log'] = $ins_data['last_access_temp'];
			$this->db->insert("log_access", $ins_arr);

		} else {
			return FALSE;
		}
	}

	public function check_book_invoice ($ac_subject, $ac_key)
	{
        $this->db->select("*");
		$this->db->where("book_status", 1);
		$this->db->where("ac_lnk_key", $ac_key);
        $this->db->where("ac_subject", $ac_subject);
//        $this->db->where("ac_acct", '1201'); // ova treba da se iskomentira koga ke se izbrise tabela book
        return $this->db->get("book");
	}

	public function get_all_client_books_plot ($ac_subject)
	{
        $this->db->select("*");
		$this->db->where("book_status", 1);
        $this->db->where("ac_subject", $ac_subject);
		$this->db->order_by("ad_time_ins", 'asc');
        $result = $this->db->get("book");
		
		$out_arr['debit'] = array();
		$out_arr['credit'] = array();
		$out_arr['status'] = array();
		$out_arr['total_status'] = 0;
		
		foreach($result->result() as $row) {
			$js_timestamp = strtotime(date('Y-m-d', strtotime($row->ad_time_ins)))*1000;
			
			if (floor($row->an_debit)){
				if (isset($out_arr['debit'][$js_timestamp]))
					$out_arr['debit'][$js_timestamp] += $row->an_debit;
				else 
					$out_arr['debit'][$js_timestamp] = $row->an_debit;
			}
			
			if (floor($row->an_credit)){
				if (isset($out_arr['credit'][$js_timestamp]))
					$out_arr['credit'][$js_timestamp] += $row->an_credit;
				else 
					$out_arr['credit'][$js_timestamp] = $row->an_credit;
			}

			$out_arr['total_status'] = $out_arr['total_status'] + $row->an_credit - $row->an_debit;
			$out_arr['status'][$js_timestamp] = $out_arr['total_status'];
		}

		return $out_arr;
	}











// old code    
	public function check_has_voted ($fb_id, $client_id)
	{
		if (!is_numeric($fb_id) || $fb_id == 0 || !is_numeric($client_id) || $client_id == 0){
			return FALSE;
		}
		
		$query = "SELECT * FROM {$this->prefix}votes WHERE fb_id = '$fb_id' AND client_id = '$client_id'";
		$result = $this->db->query ($query);
		if ($result->num_rows() > 0){
			return TRUE;
		} else {
			return FALSE;
		}
	}
	
	public function insert_data ($data)
	{
		$user = $this->get_client($data['uid']);
		if ($user->num_rows() > 0){
			$user = $user->row();			
			if ($user->has_photo != 0){
				return FALSE;
			}
			
			$query = "SELECT * FROM `{$this->prefix}photos` WHERE fb_id = '{$data['uid']}'";
			$result = $this->db->query ($query);
			if ($result->num_rows() > 0){
				$photo_id = $result->row()->id;
				$ins_arr = array (
				'status'	 	=> 1,
				'created_on' 	=> date ('Y-m-d H:i:s')		
				);
				$this->db->where ('fb_id', $data['uid']);
				$this->db->update("{$this->prefix}photos", $ins_arr);
			} else {
				$ins_arr = array (
				'fb_id' 		=> $data['uid'],
				'user_name' 	=> $user->name,
				'created_on' 	=> date ('Y-m-d H:i:s'),		
				);
				$this->db->insert ("{$this->prefix}photos", $ins_arr);
				$photo_id = $this->db->insert_id ();
			}
		
			$ins_arr = array (
				'has_photo' 	=> 1,
				'photo_id' 		=> $photo_id	
			);
			$this->db->where('fb_id', $data['uid']);
			$this->db->update ("{$this->prefix}clients", $ins_arr);

		}
		return TRUE;
	}
	
	public function delete_image($fb_id) {

        $query = "SELECT * FROM {$this->prefix}photos 
                  WHERE fb_id='".mysql_real_escape_string($fb_id)."' OR teammate='".mysql_real_escape_string($fb_id)."' AND status=1";
        $result = $this->db->query($query);

        if ($result->num_rows() > 0){
            $teamleader = $result->row()->fb_id;
            $teammate = $result->row()->teammate;

            $ins_arr = array ('has_photo' => 0, 'video' => 0, 'photo_id' => NULL, 'temp_team_name' => NULL);
            $this->db->where('fb_id', $teamleader);
            $this->db->or_where('fb_id', $teammate);
            $this->db->update ("{$this->prefix}clients", $ins_arr);

            $ins_arr = array ('status' => 0, 'votes' => 0);
            $this->db->where('fb_id', $teamleader);
            $this->db->where('status', 1);
            $this->db->update ("{$this->prefix}photos", $ins_arr);		

            $query = "SELECT request_id FROM {$this->prefix}invite_teammates WHERE fb_id_from='".mysql_real_escape_string($teamleader)."'
                        OR fb_id_from='".mysql_real_escape_string($teammate)."' AND status=1 GROUP BY request_id";
            $result_invites = $this->db->query($query);
            if($result_invites->num_rows() > 0)
                foreach($result_invites->result() as $row)
                    try {
                        $this->facebook->api("/$row->request_id", "DELETE");
                    }  catch (FacebookApiException $e) {}

            $ins_arr = array('status' => 0);
            $this->db->where('fb_id_from', $teamleader);
            $this->db->or_where('fb_id_from', $teammate);
            $this->db->update("{$this->prefix}invite_teammates", $ins_arr);
            return TRUE;
        }
        return FALSE;
    }

    public function update_access_date($fb_id){
 
        $date = date ('Y-m-d');
        $query = "UPDATE {$this->prefix}photos SET access_date ='{$date}' 
                              WHERE fb_id = '{$fb_id}' AND status=1";
        $this->db->query ($query);
    }	

/*	public function get_client($uid)
	{
		$query = "SELECT * FROM `{$this->prefix}clients` WHERE fb_id = '$uid'";
		return $this->db->query ($query);
	} */

	public function get_user_image($uid)
	{
		$query = "SELECT * FROM `{$this->prefix}photos` WHERE fb_id = '$uid' AND status ='1'";
		return $this->db->query ($query);
	}

	public function count_images()
	{
		$query = "SELECT COUNT(*) as max_count FROM `{$this->prefix}photos` WHERE status=1";
		$result = $this->db->query($query);
		$result = $result->row();
		return $result->max_count;
	}

	public function get_images($start = 0)
	{
		$query = "SELECT * FROM {$this->prefix}photos";
		return $this->db->query($query);
	}
	
	public function get_ranking_images($start = 0)
	{
		$query = "SELECT * FROM {$this->prefix}photos WHERE status='1' 
				  ORDER BY level DESC, votes DESC 
				  LIMIT $start,".NUM_IMAGES_PAGE;
		return $this->db->query($query);
	}
	
	public function get_user_rank ($fb_id){
		$query = "SELECT  p.*, (
        		  SELECT  COUNT(*)
        		  FROM    {$this->prefix}photos ph
        		  WHERE   (ph.level, ph.votes, ph.id) >= (p.level, p.votes, p.id)
        		  AND ph.status = 1
       			 ) AS rank
				FROM    {$this->prefix}photos p
				WHERE   p.fb_id = '$fb_id'
				AND p.status = 1";
		$result = $this->db->query($query);
		if($result->num_rows() > 0){
			return $result->row()->rank;
		} else {
			return '';
		}
		
	}
	
	public function vote ($fb_id, $photo_fb_id)
	{
		$query = "SELECT * FROM {$this->prefix}clients WHERE fb_id = '$photo_fb_id'";
		$client = $this->db->query ($query);
		
		if ($client->num_rows() > 0){
			$client = $client->row();
			
			$ins_arr['fb_id'] = $fb_id;
			$ins_arr['client_id'] = $client->fb_id;
			$ins_arr['ip_addr'] = $this->input->ip_address();
			
			$query = "SELECT * FROM {$this->prefix}votes WHERE fb_id = '{$fb_id}' 
					  AND client_id = '{$ins_arr['client_id']}'";
			$result = $this->db->query ($query);
			
			if ($result->num_rows() == 0){
				if ($this->db->insert ("{$this->prefix}votes", $ins_arr))
				{
					$query = "UPDATE {$this->prefix}photos SET votes = votes + 1 
							  WHERE fb_id = '{$ins_arr['client_id']}' AND status = 1";
					$this->db->query ($query);
					return TRUE;
				}
			}
		}
	}
	
	public function insert_client ($fb_id)
	{
		$result = $this->get_client($fb_id);
 
        if (!$result->num_rows()){
            $response = FALSE;
            try {
                $response = $this->facebook->api("/{$fb_id}/?fields=first_name,name,last_name,email,id,gender");
            } catch (Exception $e){
                $this->log_error($fb_id, $this->facebook->getAccessToken(), 
                    'File: '.__FILE__.' Function: '.__FUNCTION__.
                    ' Message: '.$e->__toString());
                return FALSE;
            }
            if (is_array ($response)) {
                if (is_numeric ($response['id'])){
                    $ins_arr['firstname']   = $response['first_name'];
                    $ins_arr['lastname']    = $response['last_name'];
                    $ins_arr['email']       = $response['email'];
                    $ins_arr['name']        = $response['name'];
                    $ins_arr['fb_id']       = $response['id'];
                    $ins_arr['created_on']  = date('Y-m-d H:i:s');
                    $ins_arr['sex']         = $response['gender'];
                    $ins_arr['ip_addr']     = $this->input->ip_address();
                    $ins_arr['browser_string'] = $this->agent->browser() .' '. $this->agent->version();
                    $this->db->insert ("{$this->prefix}clients", $ins_arr);
                    //$this->insert_data(array('uid' => $fb_id));
                    return $this->get_client($fb_id);
                }
            }
        }
        return FALSE;
	}

	public function insert_requests_sent($request_id, $uid)
	{
		$ins_arr = array();
		$query = "INSERT IGNORE INTO {$this->prefix}requests (request_id, fb_id) VALUES ('".
					mysql_real_escape_string($request_id)."','".
					mysql_real_escape_string($uid)."')";
		$this->db->query($query);
	}

    public function insert_requests_invite_teammates($request_id, $request_to, $uid)
    {
        foreach ($request_to as $fb_id_to){
            $query = "INSERT IGNORE INTO {$this->prefix}invite_teammates (request_id, fb_id_from, fb_id_to, ip_addr) VALUES ('".
                        mysql_real_escape_string($request_id)."','".mysql_real_escape_string($uid)."','".
                        mysql_real_escape_string($fb_id_to)."','".mysql_real_escape_string($this->input->ip_address())."')";
            $this->db->query($query);
        }
    }

	public function get_request($request_id){
		$query = "SELECT fb_id FROM {$this->prefix}requests 
				  WHERE request_id='".mysql_real_escape_string($request_id)."' LIMIT 1";
		$result = $this->db->query($query);
		if ($result->num_rows()){
			return $result->row()->fb_id;
		} else {
			return FALSE;
		}
	}

	public function log_error ($fb_id, $token, $message){
		try {
			$this->load->library ('user_agent');
			$ins_arr['created_on']  = date('Y-m-d H:i:s');
			$ins_arr['ip_addr']		= $this->input->ip_address();
			$ins_arr['fb_id'] 		= $fb_id;
			$ins_arr['token'] 	    = $token;
			$ins_arr['message']	    = $message;
			$ins_arr['browser_string'] = $this->agent->browser() .' '. $this->agent->version();
			$this->db->insert ("{$this->prefix}log_fb", $ins_arr);
		} catch (Exception $e){/*do nothing?*/}
	}

    public function get_teammates_from($fb_id){
        $query = "SELECT fb_id_to FROM {$this->prefix}invite_teammates 
                  WHERE fb_id_from='".mysql_real_escape_string($fb_id)."' AND status=1 GROUP BY fb_id_to";
        return $this->db->query($query);
    }

    public function get_teammates_to($fb_id){
        $query = "SELECT fb_id_from FROM {$this->prefix}invite_teammates 
                  WHERE fb_id_to='".mysql_real_escape_string($fb_id)."' AND status=1 GROUP BY fb_id_from";
        return $this->db->query($query);
    }

    public function save_temp_team_name($temp_team_name, $fb_id){
        $query = "UPDATE {$this->prefix}clients SET temp_team_name ='{$temp_team_name}' 
                              WHERE fb_id = '{$fb_id}'"; 
        $this->db->query ($query);
    }

    public function check_accept_teammate($accepted_teammate, $fb_id){
        $query = "SELECT * FROM {$this->prefix}invite_teammates 
                  WHERE fb_id_from='".mysql_real_escape_string($accepted_teammate)."' AND fb_id_to='".mysql_real_escape_string($fb_id)."' AND status=1";
        $result = $this->db->query($query);
        if ($result->num_rows() > 0)
            return TRUE;
        return FALSE;
    }

    public function accept_teammate($accepted_teammate, $fb_id){

        $teammate_from = $this->get_client($accepted_teammate);
        if ($teammate_from->num_rows() == 0 || $teammate_from->row()->has_photo != 0)
            return FALSE;

        $teammate_to = $this->get_client($fb_id);
        if ($teammate_to->num_rows() == 0 || $teammate_to->row()->has_photo != 0)
            return FALSE;

        $result = $this->db->query("SELECT * FROM `{$this->prefix}photos` WHERE fb_id = '{$accepted_teammate}' AND status=1");

        if ($result->num_rows() > 0)
            return FALSE;

        $ins_arr = array('fb_id' => $accepted_teammate, 'teammate' => $fb_id, 'user_name' => $teammate_from->row()->temp_team_name, 'created_on' => date('Y-m-d H:i:s'));
        $this->db->insert ("{$this->prefix}photos", $ins_arr);

        $ins_arr = array('has_photo' => 1, 'photo_id' => $this->db->insert_id());
        $this->db->where('fb_id', $accepted_teammate);
        $this->db->or_where('fb_id', $fb_id);
        $this->db->update("{$this->prefix}clients", $ins_arr);

        $query = "SELECT request_id FROM {$this->prefix}invite_teammates WHERE fb_id_from='".mysql_real_escape_string($accepted_teammate)."'
                  OR fb_id_from='".mysql_real_escape_string($fb_id)."' AND status=1 GROUP BY request_id";
        $result = $this->db->query($query);
        if($result->num_rows() > 0)
            foreach($result->result() as $row)
                try {
                    $this->facebook->api("/$row->request_id", "DELETE");
                }  catch (FacebookApiException $e) {}

        $ins_arr = array('status' => 0);
        $this->db->where('fb_id_from', $accepted_teammate);
        $this->db->or_where('fb_id_from', $fb_id);
        $this->db->update("{$this->prefix}invite_teammates", $ins_arr);

        return TRUE;
    }

    public function check_photos_teammate($fb_id){
        $query = "SELECT * FROM {$this->prefix}photos 
                  WHERE fb_id='".mysql_real_escape_string($fb_id)."' OR teammate='".mysql_real_escape_string($fb_id)."' AND status=1";
        $result = $this->db->query($query);
        if ($result->num_rows() > 0)
            return array('teamleader' => $result->row()->fb_id, 'teammate' => $result->row()->teammate);
        return array('teamleader' => $fb_id, 'teammate' => $fb_id);
    }

    public function get_questions_answers($id){
        $this->db->select("*, {$this->prefix}answers.id as answers_ids");
        $this->db->join("{$this->prefix}questions", "{$this->prefix}questions.id = {$this->prefix}answers.questions_id", "left");
        $this->db->where("{$this->prefix}answers.questions_id", $id);
        return $this->db->get("{$this->prefix}answers");
    }

    public function get_current_level_votes_limit($id){
        $this->db->select("level_votes");
        $this->db->where("id", $id);
        $result = $this->db->get("{$this->prefix}questions");
        
        if($result->num_rows() > 0)
            return $result->row()->level_votes;
        else
            return 0;
    }

    public function update_level($fb_id, $level){
        $ins_arr = array('level' => $level);
        $this->db->where('fb_id', $fb_id);
        $this->db->where('status', 1);
        $this->db->update("{$this->prefix}photos", $ins_arr);
    }

    public function update_video_view($fb_id){
        $ins_arr = array('video' => 1);
        $this->db->where('fb_id', $fb_id);
        $this->db->update("{$this->prefix}clients", $ins_arr);
    }
    
    public function zpay_mark_invoice_paid($invoice_number) {
        $data = array(
        	'invoice_paid' => 1
        	);
        $this->db->where('ac_key', $invoice_number);
        $this->db->update('invoice',$data);
    }
    
}
